/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased.tracetree;

import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.tracebased.tracetree.CompositeTraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.ITraceTreeNode;

public class TransactionTraceTreeNode
extends CompositeTraceTreeNode {
    private int level = 0;
    private boolean subTransaction = false;
    private boolean aborted = false;
    private boolean undoable = false;
    private boolean committed = false;

    public TransactionTraceTreeNode(ITraceTreeNode parent, String id, ICoreNotificationObject startEvent, boolean lowerThanParent, boolean undoable) {
        this(parent, id, startEvent, lowerThanParent);
        this.undoable = undoable;
    }

    public TransactionTraceTreeNode(ITraceTreeNode parent, String id, ICoreNotificationObject startEvent, boolean lowerThanParent) {
        super(parent, id, startEvent);
        if (parent instanceof TransactionTraceTreeNode) {
            this.level = ((TransactionTraceTreeNode)parent).getLevel();
            if (lowerThanParent) {
                ++this.level;
            } else {
                if (this.level > 0) {
                    --this.level;
                }
                this.committed = true;
            }
            if (this.level > 0) {
                this.subTransaction = true;
            }
        }
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isSubTransaction() {
        return this.subTransaction;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public String toString() {
        String superString = super.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(superString);
        if (this.subTransaction) {
            sb.append("; SubTr - ");
            sb.append(this.level);
        }
        if (this.aborted) {
            sb.append("; Aborted");
        } else if (this.committed) {
            sb.append("; Committed");
        }
        return sb.toString();
    }

    public boolean isUndoable() {
        return this.undoable;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }
}

