/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.errors.reporting.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.viatra2.errors.info.ErrorInformation;
import org.eclipse.viatra2.errors.info.Location;
import org.eclipse.viatra2.errors.reporting.IErrorReporter;

public class MarkerManager
implements IErrorReporter {
    protected IResource resource;

    public MarkerManager(IResource resource) {
        this.resource = resource;
    }

    @Override
    public void reportError(ErrorInformation info) {
        try {
            int severity;
            Location location = info.getLocation();
            int offset = location.getBeginOffset();
            int endOffset = location.getEndOffset();
            Assert.isTrue((endOffset >= 0 && offset >= 0 ? 1 : 0) != 0, (String)"Error location must be set");
            int length = endOffset - offset + 1;
            if (length <= 0) {
                length = 1;
            }
            switch (info.getErrorSeverity()) {
                case INFO: {
                    severity = 0;
                    break;
                }
                case WARNING: {
                    severity = 1;
                    break;
                }
                case ERROR: {
                    severity = 2;
                    break;
                }
                default: {
                    severity = 2;
                }
            }
            this.createErrorMarker(info.getMessage(), info.getMarkerId(), severity, offset, length, location.getBeginLine());
        }
        catch (Exception exception) {
            System.out.println("Editor::reportError exception occured!!!!");
        }
    }

    boolean createErrorMarker(String message, String markerId, int severity, int offset, int length, int line) {
        if (this.resource != null) {
            try {
                IMarker marker = this.resource.createMarker(markerId);
                marker.setAttribute("severity", severity);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("lineNumber", line);
                if (offset != 0) {
                    marker.setAttribute("charStart", offset);
                    marker.setAttribute("charEnd", offset + length);
                }
                return true;
            }
            catch (Exception exc) {
                exc.printStackTrace(System.err);
            }
        }
        return false;
    }

    @Override
    public void deleteMarkers(String type) {
        if (this.resource == null) {
            return;
        }
        try {
            this.resource.deleteMarkers(type, true, 2);
        }
        catch (CoreException coreException) {}
    }
}

