/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.modelChecker.impl;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectTransactionEnd;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectUndoEnd;
import org.eclipse.viatra2.modelChecker.impl.ModelChecker;
import org.eclipse.viatra2.modelChecker.impl.ProblemCounter;

public class ConsistencyListener
implements ICoreNotificationListener {
    ProblemCounter pc;
    ModelChecker checker;
    TreeSet<IModelElement> noted = new TreeSet();

    public ConsistencyListener(ProblemCounter pc) {
        this.pc = pc;
        this.checker = new ModelChecker();
    }

    @Override
    public void actionPerformed(ICoreNotificationObject notification) {
        Collection<IModelElement> newNoted = notification.getNotifiedObjects();
        this.noted.addAll(newNoted);
        if (notification instanceof ICoreNotificationObjectTransactionEnd || notification instanceof ICoreNotificationObjectUndoEnd) {
            this.checkChanges();
        }
    }

    private void checkChanges() {
        for (IModelElement me : this.noted) {
            this.pc.pm.tm.clearTags(me);
            this.checkME(me);
            if (!(me instanceof IRelation)) continue;
            IRelation rel = (IRelation)me;
            if (!this.noted.contains(rel.getFrom())) {
                this.checkME(rel.getFrom());
            }
            if (this.noted.contains(rel.getTo())) continue;
            this.checkME(rel.getTo());
        }
        this.noted = new TreeSet();
    }

    private void checkME(IModelElement me) {
        this.pc.setProblems(me, this.checker.checkModelElement(me));
    }

    @Override
    public int getListenerCategory() {
        return 0;
    }
}

