/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.modelChecker.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.modelChecker.EProblemType;
import org.eclipse.viatra2.modelChecker.IProblem;
import org.eclipse.viatra2.modelChecker.Problem;

public class ModelChecker {
    public Collection<IProblem> checkAllModelElement(IModelSpace modelSpace) {
        try {
            Collection<IProblem> ret;
            modelSpace.getTransactionManager().beginTransaction();
            IEntity toCheck = modelSpace.getModelManager().getRoot();
            Collection<IProblem> collection = ret = this.checkBranch(toCheck);
            return collection;
        }
        finally {
            modelSpace.getTransactionManager().commitTransaction();
        }
    }

    public Collection<IProblem> checkBranch(IModelElement me) {
        ArrayList<IProblem> ret = new ArrayList<IProblem>();
        this.checkBranch(me, ret);
        return ret;
    }

    public void checkBranch(IModelElement me, Collection<IProblem> ret) {
        if (me != null) {
            this.checkModelElement(me, ret);
            Collection<IModelElement> children = me.getElementsInNamespace();
            for (IModelElement element : children) {
                this.checkBranch(element, ret);
            }
        }
    }

    public Collection<IProblem> checkModelElement(IModelElement me) {
        ArrayList<IProblem> ret = new ArrayList<IProblem>();
        this.checkModelElement(me, ret);
        return ret;
    }

    protected void checkModelElement(IModelElement me, Collection<IProblem> ret) {
        Collection<IRelation> relsFrom = me.getRelationsFrom();
        for (IRelation relation : relsFrom) {
            this.checkRelationSource(me, relation, ret);
            this.checkSourceMultiplicity(me, relation, new HashSet<IRelation>(), ret);
            if (!relation.getAllSupertypes().isEmpty()) {
                this.checkMetamodelConsistencyForRelation(me, relation, ret);
            }
            this.relationSupertypeValidation(me, relation, ret);
        }
        Collection<IRelation> relsTo = me.getRelationsTo();
        for (IRelation relation : relsTo) {
            this.checkRelationTarget(me, relation, ret);
            this.checkTargetMultiplicity(me, relation, new HashSet<IRelation>(), ret);
        }
    }

    protected void checkMetamodelConsistencyForRelation(IModelElement current, IRelation relation, Collection<IProblem> problems) {
        EMultiplicityKind subMultiplicity = relation.getMultiplicity();
        Collection<IModelElement> supertypes = relation.getSupertypes();
        for (IModelElement supertype : supertypes) {
            IRelation relSupertype = (IRelation)supertype;
            EMultiplicityKind superMultiplicity = relSupertype.getMultiplicity();
            if (!this.isMultiplicityRefinement(subMultiplicity, superMultiplicity)) {
                problems.add(new Problem(current, relation, relSupertype, EProblemType.MULTIPLICITY_REFINEMENT_INVALID));
            }
            if (!relSupertype.getIsAggregation() || relation.getIsAggregation()) continue;
            problems.add(new Problem(current, relation, relSupertype, EProblemType.AGGREGATION_REFINEMENT_INVALID));
        }
    }

    protected boolean isMultiplicityRefinement(EMultiplicityKind subMulti, EMultiplicityKind superMulti) {
        if (superMulti.compareTo(EMultiplicityKind.MANY_TO_MANY) == 0) {
            return true;
        }
        if (superMulti.compareTo(EMultiplicityKind.MANY_TO_ONE) == 0) {
            return subMulti.compareTo(EMultiplicityKind.MANY_TO_ONE) == 0 || subMulti.compareTo(EMultiplicityKind.ONE_TO_ONE) == 0;
        }
        if (superMulti.compareTo(EMultiplicityKind.ONE_TO_MANY) == 0) {
            return subMulti.compareTo(EMultiplicityKind.ONE_TO_MANY) == 0 || subMulti.compareTo(EMultiplicityKind.ONE_TO_ONE) == 0;
        }
        return superMulti.compareTo(EMultiplicityKind.ONE_TO_ONE) == 0 && subMulti.compareTo(EMultiplicityKind.ONE_TO_ONE) == 0;
    }

    protected void checkSourceMultiplicity(IModelElement current, IRelation relation, Collection<IRelation> problematicTypes, Collection<IProblem> problems) {
        Collection<IModelElement> relTypes = relation.getTypes();
        for (IModelElement type : relTypes) {
            IRelation relType = (IRelation)type;
            EMultiplicityKind multiplicity = relType.getMultiplicity();
            if (multiplicity.compareTo(EMultiplicityKind.ONE_TO_ONE) != 0 && multiplicity.compareTo(EMultiplicityKind.MANY_TO_ONE) != 0 || current.getAllRelationFromByType(relType).size() <= 1 || problematicTypes.contains(relType)) continue;
            problems.add(new Problem(current, relation, relType, EProblemType.OUTGOING_MULTIPLICITY_CONSTRAINT_VIOLATED));
            problematicTypes.add(relType);
        }
    }

    protected void checkTargetMultiplicity(IModelElement current, IRelation relation, Collection<IRelation> problematicTypes, Collection<IProblem> problems) {
        Collection<IModelElement> relTypes = relation.getTypes();
        for (IModelElement type : relTypes) {
            IRelation relType = (IRelation)type;
            EMultiplicityKind multiplicity = relType.getMultiplicity();
            if (multiplicity.compareTo(EMultiplicityKind.ONE_TO_ONE) != 0 && multiplicity.compareTo(EMultiplicityKind.ONE_TO_MANY) != 0 || current.getAllRelationToByType(relType).size() <= 1 || problematicTypes.contains(relType)) continue;
            problems.add(new Problem(current, relation, relType, EProblemType.INCOMING_MULTIPLICITY_CONSTRAINT_VIOLATED));
            problematicTypes.add(relType);
        }
    }

    protected void checkRelationSource(IModelElement current, IRelation rel, Collection<IProblem> problems) {
        if (rel.getTo() == null) {
            problems.add(new Problem(current, rel, null, EProblemType.INVALID_RELATION_TARGET));
        }
        Collection<IModelElement> relTypes = rel.getAllTypes();
        for (IModelElement type : relTypes) {
            IRelation relType = (IRelation)type;
            this.typecheckRelationSource(current, relType, rel, problems);
        }
    }

    protected void checkRelationTarget(IModelElement current, IRelation rel, Collection<IProblem> problems) {
        if (rel.getFrom() == null) {
            problems.add(new Problem(current, rel, null, EProblemType.INVALID_RELATION_SOURCE));
        }
        Collection<IModelElement> relTypes = rel.getAllTypes();
        for (IModelElement type : relTypes) {
            IRelation relType = (IRelation)type;
            this.typecheckRelationTarget(current, relType, rel, problems);
        }
    }

    protected void checkContainmentIsConsistentWithIsAggregation(IRelation rel, IRelation relType, Collection<IProblem> problems) {
        if (rel.getFrom() instanceof IEntity && rel.getTo() instanceof IEntity) {
            IEntity fromEntity = (IEntity)rel.getFrom();
            IEntity toEntity = (IEntity)rel.getTo();
            if (toEntity.getParent() != fromEntity) {
                problems.add(new Problem((IModelElement)fromEntity, rel, relType, EProblemType.AGGREGATION_INVALID));
            }
        }
    }

    protected void typecheckRelationSource(IModelElement current, IRelation relType, IRelation rel, Collection<IProblem> ret) {
        assert (current != null);
        if (relType.getIsAggregation()) {
            this.checkContainmentIsConsistentWithIsAggregation(rel, relType, ret);
        }
        Collection<IModelElement> types = current.getAllTypes();
        for (IModelElement element : types) {
            Collection<IRelation> edgeTypes = element.getRelationsFrom();
            if (!edgeTypes.contains(relType)) continue;
            return;
        }
        ret.add(new Problem(current, rel, relType, EProblemType.INVALID_RELATION_SOURCE_TYPE));
    }

    protected void typecheckRelationTarget(IModelElement current, IRelation relType, IRelation rel, Collection<IProblem> ret) {
        Collection<IModelElement> types = current.getAllTypes();
        for (IModelElement element : types) {
            Collection<IRelation> edgeTypes = element.getRelationsTo();
            if (!edgeTypes.contains(relType)) continue;
            return;
        }
        ret.add(new Problem(current, rel, relType, EProblemType.INVALID_RELATION_TARGET_TYPE));
    }

    protected void relationSupertypeValidation(IModelElement me, IRelation rel, Collection<IProblem> problems) {
        for (IModelElement subElement : rel.getSubtypes()) {
            if (subElement instanceof IRelation) {
                IRelation subRel = (IRelation)subElement;
                if (!rel.getFrom().equals(subRel.getFrom()) && !rel.getFrom().isSubtypeOf(subRel.getFrom())) {
                    problems.add(new Problem(me, rel, subRel, EProblemType.INVALID_REFINEMENT_SOURCE_TYPE));
                }
                if (rel.getTo().equals(subRel.getTo()) || rel.getTo().isSubtypeOf(subRel.getTo())) continue;
                problems.add(new Problem(me, rel, subRel, EProblemType.INVALID_REFINEMENT_TARGET_TYPE));
                continue;
            }
            if (!subElement.isEntity()) continue;
            problems.add(new Problem(me, rel, (IEntity)subElement, EProblemType.INVALID_REFINEMENT));
        }
        for (IModelElement superElement : rel.getSupertypes()) {
            if (!superElement.isEntity()) continue;
            problems.add(new Problem(me, rel, (IEntity)superElement, EProblemType.INVALID_REFINEMENT));
        }
    }

    public String printProblems(Collection<IProblem> problems) {
        if (problems == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (IProblem problem : problems) {
            buf.append("not compatible types");
            buf.append(" " + problem.getProblemType().toString() + " ");
            buf.append("(entity, relation, relation type):");
            buf.append(String.valueOf(problem.getEndPoint().getFullyQualifiedName()) + ",");
            buf.append(String.valueOf(problem.getRelation().getFullyQualifiedName()) + ",");
            buf.append(problem.getRelationType().getFullyQualifiedName());
            buf.append("\n");
        }
        return buf.toString();
    }
}

