/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.natives;

import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="add", returns={NativeFunctionParameter.ParameterType.INTEGER, NativeFunctionParameter.ParameterType.DOUBLE, NativeFunctionParameter.ParameterType.STRING}, params={@NativeFunctionParameter(name="operand1", description="first operand", type={NativeFunctionParameter.ParameterType.INTEGER, NativeFunctionParameter.ParameterType.DOUBLE, NativeFunctionParameter.ParameterType.STRING}), @NativeFunctionParameter(name="operand2", description="second operand", type={NativeFunctionParameter.ParameterType.INTEGER, NativeFunctionParameter.ParameterType.DOUBLE, NativeFunctionParameter.ParameterType.STRING})}, remark="Operand types need to be of the same type at run-time (integer+double combinations are allowed).")
public class AdderFunction
implements ASMNativeFunction {
    @Override
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        if (params.length == 2) {
            if (params[0] instanceof Integer && params[1] instanceof Integer) {
                return new Integer((Integer)params[0] + (Integer)params[1]);
            }
            if (params[0] instanceof Double && params[1] instanceof Double) {
                return new Double((Double)params[0] + (Double)params[1]);
            }
            if (params[0] instanceof String && params[1] instanceof String) {
                return String.valueOf(params[0].toString()) + params[1].toString();
            }
            if (params[0] instanceof Integer && params[1] instanceof Double) {
                return new Double((double)((Integer)params[0]).intValue() + (Double)params[1]);
            }
            if (params[0] instanceof Double && params[1] instanceof Integer) {
                return new Double((Double)params[0] + (double)((Integer)params[1]).intValue());
            }
            throw new VPMRuntimeException("Parameter type mismatch!");
        }
        throw new VPMRuntimeException("Parameter count mismatch!");
    }

    @Override
    public String getName() {
        return "add";
    }

    @Override
    public String getDescription() {
        return "adds the two parameters. Numbers are added, strings are concatenated.";
    }

    @Override
    public String getID() {
        return this.getClass().getCanonicalName();
    }
}

