/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.actions;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.exports.VTMLExporterSimple;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;

public class ExportToVTMLAction
extends ViatraTreeEditorSelectionAction {
    public static final String ID = "ViatraTreeEditor.Actions.ExportToVTMLAction";
    private ViatraTreeEditor iVTE;

    public ExportToVTMLAction(IWorkbenchPart part) {
        super(part);
        this.iVTE = (ViatraTreeEditor)part;
        this.setId(ID);
        this.setText("Export as VTML");
        this.setToolTipText("Export selected model element as VTML");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        FileDialog fop = new FileDialog(this.iVTE.getEditorSite().getShell(), 8192);
        fop.setText("Choose a file to export to");
        fop.setFilterNames(new String[]{"Viatra VTML files"});
        String fn = fop.open();
        if (fn != null) {
            FileWriter fw;
            Iterator it = this.getSelectedObjects().iterator();
            try {
                fw = new FileWriter(fn, false);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            PrintWriter pw = new PrintWriter(fw);
            IModelSpace ms = this.iVTE.getFramework().getTopmodel();
            while (it.hasNext()) {
                try {
                    IModelElement me = (IModelElement)it.next();
                    VTMLExporterSimple.exportToVTML((PrintWriter)pw, (IModelSpace)ms, (IModelElement)me);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            pw.close();
            try {
                fw.close();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            this.iVTE.showMessage("Export to " + fn + " successful");
        }
    }

    @Override
    public void updateSelf() {
        if (this.getSelectedObjects().size() == 1 && this.getSelectedObjects().getFirstElement() instanceof IEntity) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

