/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.providers;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectMoveTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetName;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetValue;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetViewInfo;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionBegin;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoableTransactionBegin;
import org.eclipse.viatra2.treeeditor.providers.ViatraContentProvider;

public class ViatraTreeviewNotificationHandler
implements ICoreNotificationListener {
    private TreeViewer iTreeViewer;
    private ViatraContentProvider iContentProvider;
    private boolean inTransaction = false;
    private boolean signalDirty = false;

    public ViatraTreeviewNotificationHandler(TreeViewer tv, ViatraContentProvider cp) {
        this.iTreeViewer = tv;
        this.iContentProvider = cp;
    }

    private void refreshTreeViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViatraTreeviewNotificationHandler.this.iTreeViewer.refresh();
            }
        });
    }

    public void actionPerformed(final ICoreNotificationObject notification) {
        switch (notification.getActionTypeEnum()) {
            case TA_TRANSACTION_BEGIN: {
                Object info = ((NotificationObjectTransactionBegin)notification).getInfo();
                if (info instanceof Boolean && ((Boolean)info).booleanValue()) {
                    this.inTransaction = true;
                }
                return;
            }
            case TA_UNDOABLE_TRANSACTION_BEGIN: {
                Object info = ((NotificationObjectUndoableTransactionBegin)notification).getInfo();
                if (info instanceof Boolean && ((Boolean)info).booleanValue()) {
                    this.inTransaction = true;
                }
                return;
            }
            case TA_UNDO_BEGIN: {
                this.inTransaction = true;
                return;
            }
            case TA_TRANSACTION_END: {
                this.inTransaction = false;
                this.refreshTreeViewer();
                if (this.signalDirty) {
                    this.iContentProvider.setDirty();
                    this.signalDirty = false;
                }
                return;
            }
            case TA_UNDO_END: {
                this.inTransaction = false;
                this.refreshTreeViewer();
                if (this.signalDirty) {
                    this.iContentProvider.setDirty();
                    this.signalDirty = false;
                }
                return;
            }
        }
        if (this.inTransaction) {
            this.signalDirty = true;
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ViatraTreeviewNotificationHandler.this.handleNotification(notification);
            }
        });
    }

    private void handleNotification(ICoreNotificationObject notification) {
        switch (notification.getActionTypeEnum()) {
            case ACTION_SET_NAME: {
                ICoreNotificationObjectSetName n = (ICoreNotificationObjectSetName)notification;
                this.iTreeViewer.update((Object)n.getElement(), null);
                for (IModelElement inst_elem : n.getElement().getInstances()) {
                    this.iTreeViewer.update((Object)inst_elem, null);
                }
                for (IModelElement st_elem : n.getElement().getSubtypes()) {
                    this.iTreeViewer.update((Object)st_elem, null);
                }
                for (IRelation trg_rel : n.getElement().getRelationsTo()) {
                    this.iTreeViewer.update((Object)trg_rel, null);
                }
                break;
            }
            case ACTION_SET_VALUE: {
                ICoreNotificationObjectSetValue n1 = (ICoreNotificationObjectSetValue)notification;
                this.iTreeViewer.update((Object)n1.getEntity(), new String[]{"name"});
                break;
            }
            case ACTION_CREATE_INSTANCEOF: {
                ICoreNotificationObjectCreateInstanceOf n2 = (ICoreNotificationObjectCreateInstanceOf)notification;
                this.iTreeViewer.update((Object)n2.getInstance(), new String[]{"name"});
                break;
            }
            case ACTION_DELETE_INSTANCEOF: {
                ICoreNotificationObjectDeleteInstanceOf n3 = (ICoreNotificationObjectDeleteInstanceOf)notification;
                this.iTreeViewer.update((Object)n3.getInstance(), new String[]{"name"});
                break;
            }
            case ACTION_CREATE_SUPERTYPEOF: {
                ICoreNotificationObjectCreateSupertypeOf n4 = (ICoreNotificationObjectCreateSupertypeOf)notification;
                this.iTreeViewer.update((Object)n4.getSub(), new String[]{"name"});
                break;
            }
            case ACTION_DELETE_SUPERTYPEOF: {
                ICoreNotificationObjectDeleteSupertypeOf n5 = (ICoreNotificationObjectDeleteSupertypeOf)notification;
                this.iTreeViewer.update((Object)n5.getSub(), new String[]{"name"});
                break;
            }
            case ACTION_SET_VIEW_INFO: {
                ICoreNotificationObjectSetViewInfo n6 = (ICoreNotificationObjectSetViewInfo)notification;
                this.iTreeViewer.update((Object)n6.getElement(), new String[]{"name"});
                break;
            }
            case ACTION_CREATE_ENTITY: {
                ICoreNotificationObjectCreateEntity n7 = (ICoreNotificationObjectCreateEntity)notification;
                this.iTreeViewer.add((Object)n7.getContainer(), (Object)n7.getCreated());
                break;
            }
            case ACTION_CREATE_RELATION: {
                ICoreNotificationObjectCreateRelation n8 = (ICoreNotificationObjectCreateRelation)notification;
                this.iTreeViewer.add((Object)n8.getFrom(), (Object)n8.getNewRelation());
                break;
            }
            case ACTION_MOVE_ELEMENT_TO: {
                ICoreNotificationObjectMoveTo n9 = (ICoreNotificationObjectMoveTo)notification;
                this.iTreeViewer.remove((Object)n9.getElement());
                this.iTreeViewer.add((Object)n9.getNewContainer(), (Object)n9.getElement());
                break;
            }
            case ACTION_DELETE_ENTITY: {
                ICoreNotificationObjectDeleteEntity n10 = (ICoreNotificationObjectDeleteEntity)notification;
                this.iTreeViewer.remove((Object)n10.getDeleted());
                break;
            }
            case ACTION_DELETE_RELATION: {
                ICoreNotificationObjectDeleteRelation n11 = (ICoreNotificationObjectDeleteRelation)notification;
                this.iTreeViewer.remove((Object)n11.getDeleted());
                break;
            }
            case ACTION_DELETE_CONTAINMENT: {
                break;
            }
            case ACTION_SET_RELATION_FROM: {
                ICoreNotificationObjectSetRelationFrom n12 = (ICoreNotificationObjectSetRelationFrom)notification;
                this.iTreeViewer.remove((Object)n12.getRelation());
                this.iTreeViewer.add((Object)n12.getNewFrom(), (Object)n12.getRelation());
                break;
            }
            case ACTION_SET_RELATION_TO: {
                ICoreNotificationObjectSetRelationTo n13 = (ICoreNotificationObjectSetRelationTo)notification;
                this.iTreeViewer.update((Object)n13.getRelation(), new String[]{"name"});
            }
        }
        this.iContentProvider.setDirty();
    }

    public int getListenerCategory() {
        return 0;
    }
}

