/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.transfer;

import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.commands.AddSupertypeCommand;
import org.eclipse.viatra2.treeeditor.commands.AddTypeCommand;
import org.eclipse.viatra2.treeeditor.commands.MoveModelElementCommand;
import org.eclipse.viatra2.treeeditor.commands.RetargetRelationCommand;
import org.eclipse.viatra2.treeeditor.commands.ViatraCompoundCommand;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommand;
import org.eclipse.viatra2.treeeditor.transfer.ViatraTransfer;
import org.eclipse.viatra2.treeeditor.transfer.ViatraTransferData;

public class ViatraEditorDropTargetAdapter
extends DropTargetAdapter {
    protected ViatraTreeEditor iVTE;

    public ViatraEditorDropTargetAdapter(ViatraTreeEditor vte) {
        this.iVTE = vte;
    }

    public static Transfer[] getTransfers() {
        Transfer[] r = new Transfer[]{ViatraTransfer.getInstance()};
        return r;
    }

    public void drop(DropTargetEvent event) {
        if (event != null && event.data != null && event.item != null && event.data instanceof ViatraTransferData[]) {
            String fqn;
            ViatraTransferData[] data = (ViatraTransferData[])event.data;
            int i = 0;
            while (i < data.length) {
                IModelElement target = (IModelElement)event.item.getData();
                fqn = data[i].fullyQualifiedName;
                IModelElement item = target.getModelSpace().getModelManager().getElementByName(fqn);
                if (target.equals(item)) {
                    return;
                }
                ++i;
            }
            ViatraCompoundCommand ccmd = new ViatraCompoundCommand();
            int i2 = 0;
            while (i2 < data.length) {
                ViatraEditorCommand cmd;
                IModelElement item;
                fqn = data[i2].fullyQualifiedName;
                IModelElement target = (IModelElement)event.item.getData();
                if (target.equals(item = target.getModelSpace().getModelManager().getElementByName(fqn))) {
                    return;
                }
                if (event.detail == 1) {
                    cmd = new AddTypeCommand();
                    ((AddTypeCommand)cmd).setTypeElem(item);
                    ((AddTypeCommand)cmd).setTargetElem(target);
                    ccmd.add(cmd);
                } else if (event.detail == 4) {
                    cmd = new AddSupertypeCommand();
                    ((AddSupertypeCommand)cmd).setSupertypeElem(item);
                    ((AddSupertypeCommand)cmd).setTargetElem(target);
                    ccmd.add(cmd);
                } else if (target instanceof IEntity) {
                    cmd = new MoveModelElementCommand();
                    if (item instanceof IEntity) {
                        ((MoveModelElementCommand)cmd).setEntity((IEntity)item, (IEntity)target);
                    } else if (item instanceof IRelation) {
                        ((MoveModelElementCommand)cmd).setRelation((IRelation)item, target);
                    }
                    ccmd.add(cmd);
                } else if (target instanceof IRelation) {
                    if (item instanceof IRelation) {
                        cmd = new MoveModelElementCommand();
                        ((MoveModelElementCommand)cmd).setRelation((IRelation)item, target);
                        ccmd.add(cmd);
                    } else if (item instanceof IEntity) {
                        cmd = new RetargetRelationCommand();
                        ((RetargetRelationCommand)cmd).setRelation((IRelation)target, item);
                        ccmd.add(cmd);
                    }
                }
                ++i2;
            }
            if (!ccmd.isEmpty()) {
                this.iVTE.getCommandStack().execute(ccmd);
                this.iVTE.updateActions();
            }
        }
    }
}

