/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.term.rules;

import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterErrorString;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ModelElementQuery;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Aggregate;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.ElementReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.FullyQualifiedName;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Inverse;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Multiplicity;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Name;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Source;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Target;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Value;

public class ModelElementQueryEvaluator
extends TermEvaluator {
    private static ModelElementQueryEvaluator _instance = new ModelElementQueryEvaluator();

    private ModelElementQueryEvaluator() {
    }

    public static ModelElementQueryEvaluator getInstance() {
        return _instance;
    }

    @Override
    public Object evaluate(IExecutionEnvironment executionEnvironment, Term termToBeEvaluated) throws ViatraTransformationException {
        ModelElementQuery modelElementQuery = (ModelElementQuery)termToBeEvaluated;
        Object result = TermEvaluator.getInstance().evaluate(executionEnvironment, modelElementQuery.getArgument());
        if (modelElementQuery instanceof Aggregate) {
            if (!(result instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_RELATION_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return ((IRelation)result).getIsAggregation();
        }
        if (modelElementQuery instanceof FullyQualifiedName) {
            if (!(result instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_MODELELEMENT_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return ((IModelElement)result).getFullyQualifiedName();
        }
        if (modelElementQuery instanceof Name) {
            if (!(result instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_MODELELEMENT_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return ((IModelElement)result).getName();
        }
        if (modelElementQuery instanceof ElementReference) {
            if (!(result instanceof String)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_STRING_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            result = executionEnvironment.getFramework().getTopmodel().getModelManager().getElementByName((String)result);
            return result != null ? result : ValueKind.UNDEF_LITERAL;
        }
        if (modelElementQuery instanceof Value) {
            if (!(result instanceof IEntity)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_ENTITY_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return ((IEntity)result).getValue();
        }
        if (modelElementQuery instanceof Multiplicity) {
            if (!(result instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_RELATION_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return ((IRelation)result).getMultiplicity();
        }
        if (modelElementQuery instanceof Inverse) {
            if (!(result instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_RELATION_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return ((IRelation)result).getInverse();
        }
        if (modelElementQuery instanceof Target) {
            if (!(result instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_RELATION_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return (result = ((IRelation)result).getTo()) != null ? result : ValueKind.UNDEF_LITERAL;
        }
        if (modelElementQuery instanceof Source) {
            if (!(result instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(result)) {
                    String[] context = new String[]{modelElementQuery.getName()};
                    throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_EXIST_MODELELEMENTQUERY, context, termToBeEvaluated);
                }
                String[] context = new String[]{modelElementQuery.getName(), this.convertToJavaType(result)};
                throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_RELATION_MODELELEMENTQUERY, context, termToBeEvaluated);
            }
            return (result = ((IRelation)result).getFrom()) != null ? result : ValueKind.UNDEF_LITERAL;
        }
        String[] context = new String[]{modelElementQuery.getName()};
        throw new TermInterpreterException(TermInterpreterErrorString.UNIMP_MODELQUERY, context, termToBeEvaluated);
    }

    public static /* bridge */ /* synthetic */ TermEvaluator getInstance() {
        return ModelElementQueryEvaluator.getInstance();
    }
}

