/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContainmentMode implements Enumerator
{
    IN_LITERAL(0, "in", "in"),
    BELOW_LITERAL(1, "below", "below");

    public static final String copyright = " * Copyright (c) 2006-2010 Istvan Rath and Daniel Varro\r\n * All rights reserved. This program and the accompanying materials\r\n * are made available under the terms of the Eclipse Public License v1.0\r\n * which accompanies this distribution, and is available at\r\n * http://www.eclipse.org/legal/epl-v10.html\r\n *\r\n * Contributors:\r\n *    Istvan Rath, Daniel Varro - initial API and implementation\r\n";
    public static final int IN = 0;
    public static final int BELOW = 1;
    private static final ContainmentMode[] VALUES_ARRAY;
    public static final List<ContainmentMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContainmentMode[]{IN_LITERAL, BELOW_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContainmentMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainmentMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainmentMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainmentMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainmentMode get(int value) {
        switch (value) {
            case 0: {
                return IN_LITERAL;
            }
            case 1: {
                return BELOW_LITERAL;
            }
        }
        return null;
    }

    private ContainmentMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

