/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal;

import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.patternmatcher.ExecutionMode;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternMatcherParameters;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GraphTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IGTRuleMatcher;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.SymbolicRuleParameter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.logger.Logger;

public abstract class GTRuleMatcher
implements IGTRuleMatcher {
    protected Logger logger;
    protected IModelManager manager;
    protected GTRule gtRule;
    protected IExecutionEnvironment gtEnvironment = null;
    protected ITermHandler handler;

    public GTRuleMatcher(Logger logger, IModelManager manager, GTRule gtRule) {
        this.logger = logger;
        this.manager = manager;
        this.gtRule = gtRule;
    }

    protected PatternMatcherParameters initLHSPattern(PatternCallSignature[] symSignatures, Object[] symInputMapping, Integer[] symQuantificationOrder) throws ViatraTransformationException {
        PatternCallSignature[] lhsSignatures = new PatternCallSignature[this.gtRule.getPrecondition().getActualParameters().size()];
        Object[] lhsInputMapping = new Object[this.gtRule.getPrecondition().getActualParameters().size()];
        Integer[] lhsQuantification = new Integer[this.gtRule.getPrecondition().getActualParameters().size()];
        int forallQuantificationNumber = 0;
        int i = 0;
        while (i < symSignatures.length) {
            SymbolicRuleParameter symParam = (SymbolicRuleParameter)this.gtRule.getSymParameters().get(i);
            if (symParam.getVariable().getReferences().size() > 0) {
                if (this.getActualParameterIndexofSymbolicParameter(this.gtRule.getPrecondition(), symParam) != -1) {
                    lhsSignatures[this.getActualParameterIndexofSymbolicParameter((GTPatternCall)this.gtRule.getPrecondition(), (SymbolicRuleParameter)symParam)] = symSignatures[i];
                    lhsInputMapping[this.getActualParameterIndexofSymbolicParameter((GTPatternCall)this.gtRule.getPrecondition(), (SymbolicRuleParameter)symParam)] = symInputMapping[i];
                    if (symQuantificationOrder != null) {
                        lhsQuantification[this.getSymQuantificationIndex((Integer)Integer.valueOf((int)i), (Integer[])symQuantificationOrder)] = this.getActualParameterIndexofSymbolicParameter(this.gtRule.getPrecondition(), symParam);
                        ++forallQuantificationNumber;
                    }
                }
            } else {
                this.logger.warning(String.valueOf(symParam.getVariable().getName()) + " is never used inside " + this.gtRule.getName() + ".");
            }
            ++i;
        }
        int j = 0;
        while (j < this.gtRule.getPrecondition().getActualParameters().size()) {
            if (lhsSignatures[j] == null) {
                lhsSignatures[j] = new PatternCallSignature();
                lhsSignatures[j].setExecutionMode(ExecutionMode.SINGLE_RESULT);
                lhsSignatures[j].setParameterMode(ParameterMode.OUTPUT);
                lhsSignatures[j].setParameterScope(new Scope());
                lhsInputMapping[j] = ValueKind.UNDEF_LITERAL;
                if (symQuantificationOrder != null) {
                    lhsQuantification[forallQuantificationNumber] = j;
                    ++forallQuantificationNumber;
                }
            }
            ++j;
        }
        return new PatternMatcherParameters(lhsSignatures, lhsInputMapping, lhsQuantification);
    }

    private int getSymQuantificationIndex(Integer symParamIndex, Integer[] symQuantificationOrder) throws ViatraTransformationException {
        int j = 0;
        while (j < symQuantificationOrder.length) {
            if (symQuantificationOrder[j].compareTo(symParamIndex) == 0) {
                return j;
            }
            ++j;
        }
        String[] context = new String[]{((SymbolicRuleParameter)this.gtRule.getSymParameters().get(symParamIndex.intValue())).getVariable().getName(), this.gtRule.getName()};
        throw new GraphTransformationException("The {1} input symbolic parameter is not quantified by the invoking rule" + this.gtRule.getName(), context, (AnnotatedElement)this.gtRule);
    }

    protected int getActualParameterIndexof(GTPatternCall gtPattCall, Variable var) {
        for (Object obj : var.getReferences()) {
            if (!gtPattCall.getActualParameters().contains(obj)) continue;
            return gtPattCall.getActualParameters().indexOf(obj);
        }
        return -1;
    }

    protected int getActualParameterIndexofSymbolicParameter(GTPatternCall gtPattCall, SymbolicRuleParameter symParam) {
        return this.getActualParameterIndexof(gtPattCall, symParam.getVariable());
    }

    protected Object[] getOutPutSymbolicParatemerRules() throws ViatraTransformationException {
        Object[] values = new Object[this.gtRule.getSymParameters().size()];
        int i = 0;
        while (i < this.gtRule.getSymParameters().size()) {
            SymbolicRuleParameter symParam = (SymbolicRuleParameter)this.gtRule.getSymParameters().get(i);
            values[i] = this.gtEnvironment.getVariableValue(symParam.getVariable());
            ++i;
        }
        return values;
    }
}

