/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTRuleBuildingException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTElementMapping;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTElementMappingType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateEntity;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateRelationBound2Bound;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateRelationBound2Constant;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateRelationConstant2Bound;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateRelationConstant2Constant;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.DeleteModelElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.IUpdatePlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.MoveBoundunderBound;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.MoveElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.SetRelation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.SetRelationSource;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.SetRelationTarget;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.validation.GTValidationElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms.ISearchGraph;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ISearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.ConstantSearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphNode;

public class GTRuleValidator {
    private Map<Integer, GTValidationElement> validationElements = new HashMap<Integer, GTValidationElement>();

    private GTValidationElement getValidationElement(Integer i) {
        if (!this.validationElements.containsKey(i)) {
            this.validationElements.put(i, new GTValidationElement());
        }
        return this.validationElements.get(i);
    }

    public void addElements(Collection<IUpdatePlanOperation> operations) {
        for (IUpdatePlanOperation op : operations) {
            this.addElement(op);
        }
    }

    private void addElement(IUpdatePlanOperation operation) {
        if (operation instanceof CreateElement) {
            if (operation instanceof CreateEntity) {
                this.getValidationElement(((CreateEntity)operation).getVariableIndex()).addCreateOperation((CreateEntity)operation);
            } else if (operation instanceof CreateRelationBound2Bound) {
                this.getValidationElement(((CreateRelationBound2Bound)operation).getVariableIndex()).addCreateOperation((CreateRelationBound2Bound)operation);
                this.getValidationElement(((CreateRelationBound2Bound)operation).getTarget()).addRelatedCreateOperation((CreateRelationBound2Bound)operation);
                this.getValidationElement(((CreateRelationBound2Bound)operation).getSource()).addRelatedCreateOperation((CreateRelationBound2Bound)operation);
            } else if (operation instanceof CreateRelationBound2Constant) {
                this.getValidationElement(((CreateRelationBound2Constant)operation).getVariableIndex()).addCreateOperation((CreateRelationBound2Constant)operation);
                this.getValidationElement(((CreateRelationBound2Constant)operation).getSource()).addRelatedCreateOperation((CreateRelationBound2Constant)operation);
            } else if (operation instanceof CreateRelationConstant2Bound) {
                this.getValidationElement(((CreateRelationConstant2Bound)operation).getVariableIndex()).addCreateOperation((CreateRelationConstant2Bound)operation);
                this.getValidationElement(((CreateRelationConstant2Bound)operation).getTarget()).addRelatedCreateOperation((CreateRelationConstant2Bound)operation);
            } else if (operation instanceof CreateRelationConstant2Constant) {
                this.getValidationElement(((CreateRelationConstant2Constant)operation).getVariableIndex()).addCreateOperation((CreateRelationConstant2Constant)operation);
            }
        } else if (operation instanceof DeleteModelElement) {
            this.getValidationElement(((DeleteModelElement)operation).getVariableIndex()).addDelOperation((DeleteModelElement)operation);
        } else if (operation instanceof MoveElement) {
            this.getValidationElement(((MoveElement)operation).getVariableIndex()).addMoveOperation((MoveElement)operation);
            if (operation instanceof MoveBoundunderBound) {
                this.getValidationElement(((MoveBoundunderBound)operation).getContainer()).addRelatedMoveOperation((MoveElement)operation);
            }
        } else if (operation instanceof SetRelation) {
            this.getValidationElement(((SetRelation)operation).getRelation()).addSetOperation((SetRelation)operation);
        }
    }

    private void basicValidation(ISearchGraph searchGraph) throws GTRuleBuildingException {
        for (Map.Entry<Integer, GTValidationElement> entry : this.validationElements.entrySet()) {
            GTValidationElement element = entry.getValue();
            if (element.getDelOperations().size() > 1) {
                String[] context = new String[]{searchGraph.getSearchNode(entry.getKey()).getName()};
                throw new GTRuleBuildingException("More than one delete operation is defined over the {1} element", context, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(entry.getKey())));
            }
            if (element.getCreateOperations().size() > 1) {
                String[] context = new String[]{searchGraph.getSearchNode(entry.getKey()).getName()};
                throw new GTRuleBuildingException("More then one create operation is defined on the {1} element", context, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(entry.getKey())));
            }
            if (element.getDelOperations().size() == 1 && (element.createOperations.size() != 0 || element.moveOperations.size() != 0 || element.setOperations.size() != 0)) {
                String[] context = new String[]{searchGraph.getSearchNode(entry.getKey()).getName(), "" + element.createOperations.size(), "" + element.moveOperations.size(), "" + element.setOperations.size()};
                throw new GTRuleBuildingException("Conflicting operations on the {1} element. One delete operation and additionally {2} create, {3} move and {4} set operation(s)", context, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(entry.getKey())));
            }
            if (element.getRelatedCreateOperations().size() <= 0 && element.getRelatedMoveOperations().size() <= 0 && element.getRelatedSetOperations().size() <= 0 || element.getDelOperations().size() != 1) continue;
            String[] context = new String[]{searchGraph.getSearchNode(entry.getKey()).getName()};
            throw new GTRuleBuildingException("The {1} element is deleted but also invovled in other operations", context, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(entry.getKey())));
        }
    }

    private void gtElementMappingValidation(Collection<GTElementMapping> elementMappings, Collection<ISearchPlanOperation> checkSet, ISearchGraph searchGraph) throws GTRuleBuildingException {
        for (GTElementMapping mapping : elementMappings) {
            String[] context;
            GTValidationElement element = null;
            if (!this.validationElements.containsKey(mapping.getRhsInputOrderIndex())) continue;
            element = this.validationElements.get(mapping.getRhsInputOrderIndex());
            if (mapping.getMappingType().equals((Object)GTElementMappingType.KEEP)) {
                if (element.getDelOperations().size() != 0) {
                    String[] context2 = new String[]{searchGraph.getSearchNode(mapping.getRhsInputOrderIndex()).getName()};
                    throw new GTRuleBuildingException("The {1} input variable is specified to be kept and also to be deleted", context2, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(mapping.getRhsInputOrderIndex())));
                }
            } else if (element.getDelOperations().size() != 1) {
                String[] context3 = new String[]{searchGraph.getSearchNode(mapping.getRhsInputOrderIndex()).getName()};
                throw new GTRuleBuildingException("[INTERNAL ERROR] No delete operation on the '{1}' deletable parameter of the LHS", context3, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(mapping.getRhsInputOrderIndex())));
            }
            if (element.getSetOperations().size() <= 1) continue;
            int to = 0;
            int from = 0;
            for (SetRelation setR : element.getSetOperations()) {
                if (setR instanceof SetRelationSource) {
                    ++from;
                    continue;
                }
                if (!(setR instanceof SetRelationTarget)) continue;
                ++to;
            }
            if (to == 1 && from > 1) {
                context = new String[]{searchGraph.getSearchNode(mapping.getRhsInputOrderIndex()).getName()};
                throw new GTRuleBuildingException("The Source of the {1} relation is set more than once", context, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(mapping.getRhsInputOrderIndex())));
            }
            if (to > 1 && from == 1) {
                context = new String[]{searchGraph.getSearchNode(mapping.getRhsInputOrderIndex()).getName()};
                throw new GTRuleBuildingException("The Target of the {1} relation is set more than once", context, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(mapping.getRhsInputOrderIndex())));
            }
            if (to <= true || from <= 1) continue;
            context = new String[]{searchGraph.getSearchNode(mapping.getRhsInputOrderIndex()).getName()};
            throw new GTRuleBuildingException("Both the source and target of the {1} relation is set more than once", context, searchGraph.getGTASMRepresentation(searchGraph.getSearchNode(mapping.getRhsInputOrderIndex())));
        }
    }

    public void validateOperationPlan(Collection<IUpdatePlanOperation> nonchangeableGTOperations, Collection<ISearchPlanOperation> checkSet, Collection<GTElementMapping> elementMappings, ISearchGraph searchGraph) throws GTRuleBuildingException {
        this.addElements(nonchangeableGTOperations);
        this.basicValidation(searchGraph);
        this.gtElementMappingValidation(elementMappings, checkSet, searchGraph);
    }

    public static void validateContainment(SearchGraphNode node, IModelManager manager, Map<SearchGraphNode, Boolean> hasOneInConstraint) throws GTRuleBuildingException {
        for (SearchGraphEdge edge : node.getSources()) {
            if (edge.getVPMEdgeType().equals((Object)EdgeType.IN) && edge.isSource()) {
                if (hasOneInConstraint.get(node) != null && hasOneInConstraint.get(node).booleanValue()) {
                    String[] context = new String[]{node.getName()};
                    throw new GTRuleBuildingException("{1} has more than 1 'IN' type containment constraints", context, node.getTraceabilityElement().getRepresentativeEMFElement());
                }
                hasOneInConstraint.put(node, Boolean.TRUE);
            }
            if (!edge.getVPMEdgeType().equals((Object)EdgeType.TARGET) || !edge.isSource()) continue;
            SearchGraphNode edgeNode = edge.getSourceNode();
            for (SearchGraphEdge typeEdge : edgeNode.getSources()) {
                IRelation relation;
                String fqn;
                if (!typeEdge.getVPMEdgeType().equals((Object)EdgeType.INSTANCEOF) || !(edge.getSourceNode() instanceof ConstantSearchGraphNode) || !edge.isSource() || (fqn = ((ConstantSearchGraphNode)edge.getSourceNode()).getElement()) == null || fqn.equals("vpm.entity") || fqn.equals("vpm.relation") || (relation = manager.getRelationByName(fqn)) == null || !relation.getIsAggregation()) continue;
                if (hasOneInConstraint.get(node) != null && hasOneInConstraint.get(node).booleanValue()) {
                    String[] context = new String[]{node.getName()};
                    throw new GTRuleBuildingException("{1} has more than 1 'IN' type containment constraints", context, node.getTraceabilityElement().getRepresentativeEMFElement());
                }
                hasOneInConstraint.put(node, Boolean.TRUE);
            }
        }
    }
}

