/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import java.util.Set;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class CopyValueOperation
extends CheckOperation {
    private Integer bound;
    private Integer unbound;
    private SearchGraphEdge relatedSearchGraphEdge;

    public CopyValueOperation(Integer bound, Integer unbound, SearchGraphEdge edge) {
        this.bound = bound;
        this.unbound = unbound;
        this.relatedSearchGraphEdge = edge;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        IModelElement boundElement = null;
        try {
            boundElement = (IModelElement)frame.getValue(this.bound);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.bound).getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, frame.getPattern().getSearchGraph().getSearchNode(this.bound).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (boundElement == null) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.bound).getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, frame.getPattern().getSearchGraph().getSearchNode(this.bound).getTraceabilityElement().getRepresentativeEMFElement());
        }
        frame.setValue(this.unbound, boundElement);
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.bound + " -> " + this.unbound;
    }

    @Override
    public void calculateSidewaysPassedVariables(Set<Integer> variableSet) {
        variableSet.add(this.bound);
        variableSet.remove(this.unbound);
    }

    @Override
    public void calculateLocalVariables(Set<Integer> variableSet) {
        variableSet.add(this.bound);
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return frame.getPattern().getGTASMRepresentation(this.relatedSearchGraphEdge);
    }
}

