/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.SearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public abstract class ExtendOperation
extends SearchPlanOperation {
    protected Integer unbound;
    protected SearchGraphEdge edge;
    protected Iterator iterator;

    public ExtendOperation(Integer unbound, SearchGraphEdge edge) {
        this.unbound = unbound;
        this.edge = edge;
        this.iterator = null;
    }

    @Override
    public void postprocess(MatchingFrame frame) {
        frame.setValue(this.unbound, null);
        this.iterator = null;
    }

    @Override
    public boolean execute(MatchingFrame frame) throws PatternMatcherRuntimeException {
        String next = "";
        try {
            if (this.iterator.hasNext()) {
                next = this.iterator.next();
                IModelElement modelElement = (IModelElement)next;
                frame.setValue(this.unbound, modelElement);
                return true;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.edge.getVPMEdgeType().toString(), frame.getPattern().getSearchGraph().getSearchNode(this.unbound).getName(), next.getClass().getName()};
            throw new PatternMatcherRuntimeException("Type mismatch: {2} did not evaluate to a model element (entity or relation), but to type {3} instead. Developer's note: error occurred during the '{1}' type extend operation.", context, frame.getPattern().getSearchGraph().getSearchNode(this.unbound).getTraceabilityElement().getRepresentativeEMFElement());
        }
    }

    @Override
    public void calculateSidewaysPassedVariables(Set<Integer> variableSet) {
        variableSet.remove(this.unbound);
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return frame.getPattern().getSearchGraph().getSearchNode(this.unbound).getTraceabilityElement().getRepresentativeEMFElement();
    }
}

