/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import java.util.Collection;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;

public class NACCheckOperation
extends CheckOperation {
    private IPatternMatcher patternMatcher;
    private int[] actualParameterMapping;
    private Collection<Variable> passingVariables;
    private GTPatternCall nacCall;

    public NACCheckOperation(IPatternMatcher matcher, int[] actualParameterMapping, GTPatternCall call, Collection<Variable> passingVariables) {
        this.patternMatcher = matcher;
        this.actualParameterMapping = actualParameterMapping;
        this.nacCall = call;
        this.passingVariables = passingVariables;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        Object[] actualParameters = new Object[this.actualParameterMapping.length];
        int i = 0;
        while (i < this.actualParameterMapping.length) {
            actualParameters[i] = frame.getValue(this.actualParameterMapping[i]);
            if ((actualParameters[i] == null || actualParameters[i].equals(ValueKind.UNDEF_LITERAL)) && this.passingVariables.contains(((VariableReference)this.nacCall.getActualParameters().get(i)).getVariable())) {
                String[] context = new String[]{this.nacCall.getCalledPattern().getName(), ((PatternVariable)this.nacCall.getCalledPattern().getSymParameters().get(i)).getName()};
                throw new PatternMatcherRuntimeException("False invocation of the '{1}' nac pattern. Its input '{2}' parameter is unbound and it is also an output variable for its invoking pattern. Negative patterns cannot output variables ", context, (AnnotatedElement)this.nacCall);
            }
            ++i;
        }
        try {
            return !this.patternMatcher.match(actualParameters);
        }
        catch (ViatraTransformationException e) {
            throw new PatternMatcherRuntimeException(e, (AnnotatedElement)this.nacCall);
        }
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.nacCall;
    }
}

