/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.AbstractTermCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.TermCheckExecutionEnvironment;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.ContainmentConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;

public class TermEvaluationOperation
extends AbstractTermCheckOperation {
    private IExecutionEnvironment parentEnv;
    private GTPattern pattern;
    private int uid;
    private Term term;
    private int resultSlot;
    private ContainmentConstraint containmentConstraint;

    public TermEvaluationOperation(IExecutionEnvironment parentEnv, GTPattern pattern, int uid, Term term, int resultSlot) {
        this.parentEnv = parentEnv;
        this.pattern = pattern;
        this.uid = uid;
        this.term = term;
        this.containmentConstraint = null;
        this.resultSlot = resultSlot;
    }

    public TermEvaluationOperation(IExecutionEnvironment parentEnv, GTPattern pattern, int uid, ContainmentConstraint conCons, int resultSlot) {
        this.parentEnv = parentEnv;
        this.pattern = pattern;
        this.uid = uid;
        this.term = conCons.getParent();
        this.containmentConstraint = conCons;
        this.resultSlot = resultSlot;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        TermCheckExecutionEnvironment env = new TermCheckExecutionEnvironment(this.parentEnv, this.pattern, this.uid, frame);
        Object result = null;
        try {
            result = TermEvaluator.getInstance().evaluate((IExecutionEnvironment)env, this.term);
        }
        catch (ViatraTransformationException e) {
            throw new PatternMatcherRuntimeException(e, (AnnotatedElement)(this.containmentConstraint != null ? this.containmentConstraint : this.term));
        }
        return result != null ? frame.testAndSetValue(this.resultSlot, result) : false;
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.containmentConstraint != null ? this.containmentConstraint : this.term;
    }
}

