/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ContainmentFeeder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.EntityFeeder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.GeneralizationFeeder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.InstantiationFeeder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReferenceFeeder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.RelationFeeder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.JoinNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.ProjectionIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Network;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Production;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Tunnel;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.TrimmerNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.UniquenessEnforcerNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

public class ReteBoundary<PatternDescription> {
    protected ReteEngine<PatternDescription> engine;
    protected Network network;
    protected ReteContainer headContainer;
    protected IPatternMatcherRuntimeContext<PatternDescription> context;
    IPatternMatcherContext.GeneralizationQueryDirection generalizationQueryDirection;
    protected Map<Object, Address<? extends Tunnel>> unaryRoots;
    protected Map<Object, Address<? extends Tunnel>> ternaryEdgeRoots;
    protected Map<Object, Address<? extends Tunnel>> binaryEdgeRoots;
    protected Map<PatternDescription, Address<? extends Production>> productions;
    protected Address<? extends Tunnel> containmentRoot;
    protected Address<? extends Supplier> containmentTransitiveRoot;
    protected Address<? extends Tunnel> instantiationRoot;
    protected Address<? extends Supplier> instantiationTransitiveRoot;
    protected Address<? extends Tunnel> generalizationRoot;
    protected Address<? extends Supplier> generalizationTransitiveRoot;
    protected Map<Address<? extends Receiver>, Set<Stub<Address<? extends Supplier>>>> parentStubsOfReceiver;

    public ReteBoundary(ReteEngine<PatternDescription> engine) {
        this.engine = engine;
        this.network = engine.getReteNet();
        this.headContainer = this.network.getHeadContainer();
        this.context = engine.getContext();
        this.generalizationQueryDirection = this.context.allowedGeneralizationQueryDirection();
        this.parentStubsOfReceiver = new HashMap<Address<? extends Receiver>, Set<Stub<Address<? extends Supplier>>>>();
        this.unaryRoots = new HashMap<Object, Address<? extends Tunnel>>();
        this.ternaryEdgeRoots = new HashMap<Object, Address<? extends Tunnel>>();
        this.binaryEdgeRoots = new HashMap<Object, Address<? extends Tunnel>>();
        this.productions = new HashMap<PatternDescription, Address<? extends Production>>();
        this.containmentRoot = null;
        this.containmentTransitiveRoot = null;
        this.instantiationRoot = null;
        this.generalizationRoot = null;
        this.generalizationTransitiveRoot = null;
    }

    public Object wrapElement(Object element) {
        return element;
    }

    public Object unwrapElement(Object wrapper) {
        return wrapper;
    }

    public Tuple wrapTuple(Tuple unwrapped) {
        return unwrapped;
    }

    public Tuple unwrapTuple(Tuple wrappers) {
        return wrappers;
    }

    public Address<? extends Tunnel> getUnaryRoot(Object label) {
        return this.unaryRoots.get(label);
    }

    public Address<? extends Tunnel> getTernaryEdgeRoot(Object label) {
        return this.ternaryEdgeRoots.get(label);
    }

    public Address<? extends Tunnel> accessUnaryRoot(Object typeObject) {
        Address<? extends Tunnel> tn = this.unaryRoots.get(typeObject);
        if (tn == null) {
            tn = this.headContainer.getLibrary().newUniquenessEnforcerNode(1, typeObject);
            this.unaryRoots.put(typeObject, tn);
            new EntityFeeder(tn, this.context, this.network, this, typeObject).feed();
            if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.BOTH) {
                Collection<Object> subTypes = this.context.enumerateDirectUnarySubtypes(typeObject);
                for (Object subType : subTypes) {
                    Address<Tunnel> subRoot = this.accessUnaryRoot(subType);
                    this.network.connectRemoteNodes(subRoot, tn, true);
                }
            }
        }
        return tn;
    }

    public Address<? extends Tunnel> accessTernaryEdgeRoot(Object typeObject) {
        Address<? extends Tunnel> tn = this.ternaryEdgeRoots.get(typeObject);
        if (tn == null) {
            tn = this.headContainer.getLibrary().newUniquenessEnforcerNode(3, typeObject);
            this.ternaryEdgeRoots.put(typeObject, tn);
            new RelationFeeder(tn, this.context, this.network, this, typeObject).feed();
            if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.BOTH) {
                Collection<Object> subTypes = this.context.enumerateDirectTernaryEdgeSubtypes(typeObject);
                for (Object subType : subTypes) {
                    Address<Tunnel> subRoot = this.accessTernaryEdgeRoot(subType);
                    this.network.connectRemoteNodes(subRoot, tn, true);
                }
            }
        }
        return tn;
    }

    public Address<? extends Tunnel> accessBinaryEdgeRoot(Object typeObject) {
        Address<? extends Tunnel> tn = this.binaryEdgeRoots.get(typeObject);
        if (tn == null) {
            tn = this.headContainer.getLibrary().newUniquenessEnforcerNode(2, typeObject);
            this.binaryEdgeRoots.put(typeObject, tn);
            new ReferenceFeeder(tn, this.context, this.network, this, typeObject).feed();
            if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.BOTH) {
                Collection<Object> subTypes = this.context.enumerateDirectBinaryEdgeSubtypes(typeObject);
                for (Object subType : subTypes) {
                    Address<Tunnel> subRoot = this.accessBinaryEdgeRoot(subType);
                    this.network.connectRemoteNodes(subRoot, tn, true);
                }
            }
        }
        return tn;
    }

    public Address<? extends Tunnel> accessContainmentRoot() {
        if (this.containmentRoot == null) {
            this.containmentRoot = this.headContainer.getLibrary().newUniquenessEnforcerNode(2, "$containment");
            new ContainmentFeeder(this.containmentRoot, this.context, this.network, this).feed();
        }
        return this.containmentRoot;
    }

    public Address<? extends Supplier> accessContainmentTransitiveRoot() {
        if (this.containmentTransitiveRoot == null) {
            Address<UniquenessEnforcerNode> containmentTransitiveRoot = this.headContainer.getLibrary().newUniquenessEnforcerNode(2, "$containmentTransitive");
            this.network.connectRemoteNodes(this.accessContainmentRoot(), containmentTransitiveRoot, true);
            int[] actLI = new int[]{1};
            int[] actRI = new int[1];
            Address<ProjectionIndexer> jPrimarySlot = this.headContainer.getLibrary().accessProjectionIndexer(this.accessContainmentRoot(), new TupleMask(actLI, 2));
            Address<ProjectionIndexer> jSecondarySlot = this.headContainer.getLibrary().accessProjectionIndexer(containmentTransitiveRoot, new TupleMask(actRI, 2));
            int[] actRIcomp = new int[]{1};
            TupleMask complementerMask = new TupleMask(actRIcomp, 2);
            Address<JoinNode> andCT = this.headContainer.getLibrary().accessJoinNode(jPrimarySlot, jSecondarySlot, complementerMask);
            int[] nArray = new int[2];
            nArray[1] = 2;
            int[] mask = nArray;
            Address<TrimmerNode> tr = this.headContainer.getLibrary().accessTrimmerNode(andCT, new TupleMask(mask, 3));
            this.network.connectRemoteNodes(tr, containmentTransitiveRoot, true);
            this.containmentTransitiveRoot = containmentTransitiveRoot;
        }
        return this.containmentTransitiveRoot;
    }

    public Address<? extends Tunnel> accessInstantiationRoot() {
        if (this.instantiationRoot == null) {
            this.instantiationRoot = this.headContainer.getLibrary().newUniquenessEnforcerNode(2, "$instantiation");
            new InstantiationFeeder(this.instantiationRoot, this.context, this.network, this).feed();
        }
        return this.instantiationRoot;
    }

    public Address<? extends Supplier> accessInstantiationTransitiveRoot() {
        if (this.instantiationTransitiveRoot == null) {
            Address<UniquenessEnforcerNode> instantiationTransitiveRoot = this.headContainer.getLibrary().newUniquenessEnforcerNode(2, "$instantiationTransitive");
            this.network.connectRemoteNodes(this.accessInstantiationRoot(), instantiationTransitiveRoot, true);
            int[] actLI = new int[]{1};
            int[] actRI = new int[1];
            Address<ProjectionIndexer> jPrimarySlot = this.headContainer.getLibrary().accessProjectionIndexer(this.accessGeneralizationRoot(), new TupleMask(actLI, 2));
            Address<ProjectionIndexer> jSecondarySlot = this.headContainer.getLibrary().accessProjectionIndexer(instantiationTransitiveRoot, new TupleMask(actRI, 2));
            int[] actRIcomp = new int[]{1};
            TupleMask complementerMask = new TupleMask(actRIcomp, 2);
            Address<JoinNode> andCT = this.headContainer.getLibrary().accessJoinNode(jPrimarySlot, jSecondarySlot, complementerMask);
            int[] nArray = new int[2];
            nArray[1] = 2;
            int[] mask = nArray;
            Address<TrimmerNode> tr = this.headContainer.getLibrary().accessTrimmerNode(andCT, new TupleMask(mask, 3));
            this.network.connectRemoteNodes(tr, instantiationTransitiveRoot, true);
            this.instantiationTransitiveRoot = instantiationTransitiveRoot;
        }
        return this.instantiationTransitiveRoot;
    }

    public Address<? extends Tunnel> accessGeneralizationRoot() {
        if (this.generalizationRoot == null) {
            this.generalizationRoot = this.headContainer.getLibrary().newUniquenessEnforcerNode(2, "$generalization");
            new GeneralizationFeeder(this.generalizationRoot, this.context, this.network, this).feed();
        }
        return this.generalizationRoot;
    }

    public Address<? extends Supplier> accessGeneralizationTransitiveRoot() {
        if (this.generalizationTransitiveRoot == null) {
            Address<UniquenessEnforcerNode> generalizationTransitiveRoot = this.headContainer.getLibrary().newUniquenessEnforcerNode(2, "$generalizationTransitive");
            this.network.connectRemoteNodes(this.accessGeneralizationRoot(), generalizationTransitiveRoot, true);
            int[] actLI = new int[]{1};
            int[] actRI = new int[1];
            Address<ProjectionIndexer> jPrimarySlot = this.headContainer.getLibrary().accessProjectionIndexer(this.accessGeneralizationRoot(), new TupleMask(actLI, 2));
            Address<ProjectionIndexer> jSecondarySlot = this.headContainer.getLibrary().accessProjectionIndexer(generalizationTransitiveRoot, new TupleMask(actRI, 2));
            int[] actRIcomp = new int[]{1};
            TupleMask complementerMask = new TupleMask(actRIcomp, 2);
            Address<JoinNode> andCT = this.headContainer.getLibrary().accessJoinNode(jPrimarySlot, jSecondarySlot, complementerMask);
            int[] nArray = new int[2];
            nArray[1] = 2;
            int[] mask = nArray;
            Address<TrimmerNode> tr = this.headContainer.getLibrary().accessTrimmerNode(andCT, new TupleMask(mask, 3));
            this.network.connectRemoteNodes(tr, generalizationTransitiveRoot, true);
            this.generalizationTransitiveRoot = generalizationTransitiveRoot;
        }
        return this.generalizationTransitiveRoot;
    }

    public synchronized Address<? extends Production> accessProduction(PatternDescription gtPattern) throws RetePatternBuildException {
        Address<? extends Production> pn = this.productions.get(gtPattern);
        if (pn == null) {
            this.construct(gtPattern);
            pn = this.productions.get(gtPattern);
            if (pn == null) {
                String[] args = new String[]{gtPattern.toString()};
                throw new RetePatternBuildException("Unsuccessful creation of production node for pattern {1}", args, gtPattern);
            }
        }
        return pn;
    }

    public synchronized Address<? extends Production> createProductionInternal(PatternDescription gtPattern) throws RetePatternBuildException {
        if (this.productions.containsKey(gtPattern)) {
            String[] args = new String[]{gtPattern.toString()};
            throw new RetePatternBuildException("Multiple creation attempts of production node for {1}", args, gtPattern);
        }
        HashMap<Object, Integer> posMapping = this.engine.getBuilder().getPosMapping(gtPattern);
        Address<? extends Production> pn = this.headContainer.getLibrary().newProductionNode(posMapping, gtPattern);
        this.productions.put(gtPattern, pn);
        this.context.reportPatternDependency(gtPattern);
        return pn;
    }

    protected void construct(PatternDescription gtPattern) throws RetePatternBuildException {
        this.engine.getReteNet().waitForReteTermination();
        this.engine.getBuilder().construct(gtPattern);
    }

    public void updateUnary(Direction direction, Object entity, Object typeObject) {
        Address<? extends Tunnel> root = this.unaryRoots.get(typeObject);
        if (root != null) {
            this.network.sendExternalUpdate(root, direction, new FlatTuple(this.wrapElement(entity)));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
        if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.SUPERTYPE_ONLY) {
            for (Object superType : this.context.enumerateDirectUnarySupertypes(typeObject)) {
                this.updateUnary(direction, entity, superType);
            }
        }
    }

    public void updateTernaryEdge(Direction direction, Object relation, Object from, Object to, Object typeObject) {
        Address<? extends Tunnel> root = this.ternaryEdgeRoots.get(typeObject);
        if (root != null) {
            this.network.sendExternalUpdate(root, direction, new FlatTuple(this.wrapElement(relation), this.wrapElement(from), this.wrapElement(to)));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
        if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.SUPERTYPE_ONLY) {
            for (Object superType : this.context.enumerateDirectTernaryEdgeSupertypes(typeObject)) {
                this.updateTernaryEdge(direction, relation, from, to, superType);
            }
        }
    }

    public void updateBinaryEdge(Direction direction, Object from, Object to, Object typeObject) {
        Address<? extends Tunnel> root = this.binaryEdgeRoots.get(typeObject);
        if (root != null) {
            this.network.sendExternalUpdate(root, direction, new FlatTuple(this.wrapElement(from), this.wrapElement(to)));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
        if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.SUPERTYPE_ONLY) {
            for (Object superType : this.context.enumerateDirectBinaryEdgeSupertypes(typeObject)) {
                this.updateBinaryEdge(direction, from, to, superType);
            }
        }
    }

    public void updateContainment(Direction direction, Object container, Object element) {
        if (this.containmentRoot != null) {
            this.network.sendExternalUpdate(this.containmentRoot, direction, new FlatTuple(this.wrapElement(container), this.wrapElement(element)));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
    }

    public void updateInstantiation(Direction direction, Object parent, Object child) {
        if (this.instantiationRoot != null) {
            this.network.sendExternalUpdate(this.instantiationRoot, direction, new FlatTuple(this.wrapElement(parent), this.wrapElement(child)));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
    }

    public void updateGeneralization(Direction direction, Object parent, Object child) {
        if (this.generalizationRoot != null) {
            this.network.sendExternalUpdate(this.generalizationRoot, direction, new FlatTuple(this.wrapElement(parent), this.wrapElement(child)));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
    }

    public void notifyEvaluator(Address<? extends Receiver> receiver, Tuple tuple) {
        this.network.sendExternalUpdate(receiver, Direction.INSERT, tuple);
        if (!this.engine.isParallelExecutionEnabled()) {
            this.network.waitForReteTermination();
        }
    }

    public void registerParentStubForReceiver(Address<? extends Receiver> receiver, Stub<Address<? extends Supplier>> parentStub) {
        Set<Stub<Address<? extends Supplier>>> parents = this.parentStubsOfReceiver.get(receiver);
        if (parents == null) {
            parents = new HashSet<Stub<Address<? extends Supplier>>>();
            this.parentStubsOfReceiver.put(receiver, parents);
        }
        parents.add(parentStub);
    }

    public Set<Stub<Address<? extends Supplier>>> getParentStubsOfReceiver(Address<? extends Receiver> receiver) {
        Set<Stub<Address<Supplier>>> parents = this.parentStubsOfReceiver.get(receiver);
        if (parents == null) {
            parents = Collections.emptySet();
        }
        return parents;
    }
}

