/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.helpers.TypeHelper;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.VariableDeferredPConstraint;

public abstract class BaseTypeSafePredicateCheck<PatternDescription, StubHandle>
extends VariableDeferredPConstraint<PatternDescription, StubHandle> {
    private Map<PVariable, Set<Object>> allTypeRestrictions;

    public BaseTypeSafePredicateCheck(PSystem<PatternDescription, StubHandle, ?> pSystem, Set<PVariable> affectedVariables) {
        super(pSystem, affectedVariables);
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    @Override
    protected Set<PVariable> getDeferringVariables() {
        return this.getAffectedVariables();
    }

    @Override
    public boolean isReadyAt(Stub<StubHandle> stub) {
        if (super.isReadyAt(stub)) {
            return this.checkTypeSafety(stub) == null;
        }
        return false;
    }

    protected PVariable checkTypeSafety(Stub<StubHandle> stub) {
        for (PVariable pVariable : this.getAffectedVariables()) {
            Set<Object> checkedTypeRestrictions;
            Set<Object> allTypeRestrictionsForVariable = this.getAllTypeRestrictions().get(pVariable);
            Set<Object> uncheckedTypeRestrictions = TypeHelper.subsumeTypes(allTypeRestrictionsForVariable, checkedTypeRestrictions = TypeHelper.inferTypes(pVariable, stub.getAllEnforcedConstraints()), this.pSystem.getContext());
            if (uncheckedTypeRestrictions.isEmpty()) continue;
            return pVariable;
        }
        return null;
    }

    public Map<PVariable, Set<Object>> getAllTypeRestrictions() {
        if (this.allTypeRestrictions == null) {
            this.allTypeRestrictions = new HashMap<PVariable, Set<Object>>();
            for (PVariable pVariable : this.getAffectedVariables()) {
                this.allTypeRestrictions.put(pVariable, TypeHelper.inferTypes(pVariable, pVariable.getReferringConstraints()));
            }
        }
        return this.allTypeRestrictions;
    }

    @Override
    public void raiseForeverDeferredError(Stub<StubHandle> stub) throws RetePatternBuildException {
        if (super.isReadyAt(stub)) {
            String[] args = new String[]{this.toString(), this.checkTypeSafety(stub).toString()};
            String msg = "The checking of pattern constraint {1} cannot be deferred further, but variable {2} is still not type safe. HINT: the incremental matcher is not an equation solver, please make sure that all variable values are deducible.";
            throw new RetePatternBuildException(msg, args, null);
        }
        super.raiseForeverDeferredError(stub);
    }
}

