/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.VariableDeferredPConstraint;

public class Inequality<PatternDescription, StubHandle>
extends VariableDeferredPConstraint<PatternDescription, StubHandle> {
    private PVariable who;
    private PVariable withWhom;
    private boolean weak;

    public Inequality(PSystem<PatternDescription, StubHandle, ?> pSystem, PVariable who, PVariable withWhom) {
        this(pSystem, who, withWhom, false);
    }

    public Inequality(PSystem<PatternDescription, StubHandle, ?> pSystem, PVariable who, PVariable withWhom, boolean weak) {
        super(pSystem, new HashSet<PVariable>(Arrays.asList(who, withWhom)));
        this.who = who;
        this.withWhom = withWhom;
        this.weak = weak;
    }

    @Override
    protected Set<PVariable> getDeferringVariables() {
        return this.getAffectedVariables();
    }

    @Override
    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        Map<Object, Integer> variablesIndex = stub.getVariablesIndex();
        return this.buildable.buildInjectivityChecker(stub, variablesIndex.get(this.who), new int[]{variablesIndex.get(this.withWhom)});
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(this.who.toString()) + (this.isWeak() ? "!=?" : "!=") + this.withWhom.toString();
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.who)) {
            this.who = replacement;
        }
        if (obsolete.equals(this.withWhom)) {
            this.withWhom = replacement;
        }
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    public boolean isWeak() {
        return this.weak;
    }

    public boolean isEliminable() {
        return this.isWeak() && (this.who.equals(this.withWhom) || !this.who.isDeducable() || !this.withWhom.isDeducable());
    }

    public void eliminateWeak() {
        if (this.isEliminable()) {
            this.delete();
        }
    }
}

