/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.quasitree;

import java.util.Collections;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;

class JoinCandidate<StubHandle> {
    Stub<StubHandle> primary;
    Stub<StubHandle> secondary;
    Set<Object> varPrimary;
    Set<Object> varSecondary;

    JoinCandidate(Stub<StubHandle> primary, Stub<StubHandle> secondary) {
        this.primary = primary;
        this.secondary = secondary;
        this.varPrimary = this.getPrimary().getVariablesSet();
        this.varSecondary = this.getSecondary().getVariablesSet();
    }

    public Stub<StubHandle> getPrimary() {
        return this.primary;
    }

    public Stub<StubHandle> getSecondary() {
        return this.secondary;
    }

    public String toString() {
        return String.valueOf(this.primary.toString()) + " |x| " + this.secondary.toString();
    }

    public Set<Object> getVarPrimary() {
        return this.varPrimary;
    }

    public Set<Object> getVarSecondary() {
        return this.varSecondary;
    }

    public boolean isTrivial() {
        return this.getPrimary().equals(this.getSecondary());
    }

    public boolean isCheckOnly() {
        return this.varPrimary.containsAll(this.varSecondary) || this.varSecondary.containsAll(this.varPrimary);
    }

    public boolean isDescartes() {
        return Collections.disjoint(this.varPrimary, this.varSecondary);
    }
}

