/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.quasitree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Buildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.IReteLayoutStrategy;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.helpers.BuildHelper;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.helpers.LayoutHelper;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.DeferredPConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.EnumerablePConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.quasitree.JoinCandidate;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.quasitree.JoinOrderingHeuristics;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;

public class QuasiTreeLayout<PatternDescription, StubHandle, Collector>
implements IReteLayoutStrategy<PatternDescription, StubHandle, Collector> {
    @Override
    public Stub<StubHandle> layout(PSystem<PatternDescription, StubHandle, Collector> pSystem) throws RetePatternBuildException {
        return new Scaffold(pSystem).run();
    }

    public class Scaffold {
        PSystem<PatternDescription, StubHandle, Collector> pSystem;
        PatternDescription pattern;
        IPatternMatcherContext<PatternDescription> context;
        Buildable<PatternDescription, StubHandle, Collector> buildable;
        Set<DeferredPConstraint> deferredConstraints = null;
        Set<Stub<StubHandle>> forefront = new LinkedHashSet();

        Scaffold(PSystem<PatternDescription, StubHandle, Collector> pSystem) {
            this.pSystem = pSystem;
            this.pattern = pSystem.getPattern();
            this.context = pSystem.getContext();
            this.buildable = pSystem.getBuildable();
        }

        public Stub<StubHandle> run() throws RetePatternBuildException {
            try {
                this.context.logDebug(String.valueOf(this.getClass().getSimpleName()) + ": patternbody build started");
                LayoutHelper.unifyVariablesAlongEqualities(this.pSystem);
                LayoutHelper.eliminateWeakInequalities(this.pSystem);
                LayoutHelper.eliminateInferrableUnaryTypes(this.pSystem, this.context);
                LayoutHelper.checkSanity(this.pSystem);
                this.deferredConstraints = this.pSystem.getConstraintsOfType(DeferredPConstraint.class);
                Set<EnumerablePConstraint> enumerables = this.pSystem.getConstraintsOfType(EnumerablePConstraint.class);
                for (EnumerablePConstraint enumerable : enumerables) {
                    Stub stub = enumerable.getStub();
                    this.admitStub(stub);
                }
                if (enumerables.isEmpty()) {
                    Stub stub = this.buildable.buildStartStub(new Object[0], new Object[0]);
                    this.admitStub(stub);
                }
                while (this.forefront.size() > 1) {
                    List candidates = this.generateJoinCandidates();
                    JoinOrderingHeuristics ordering = new JoinOrderingHeuristics();
                    JoinCandidate selectedJoin = Collections.min(candidates, ordering);
                    this.doJoin(selectedJoin.getPrimary(), selectedJoin.getSecondary());
                }
                assert (this.forefront.size() == 1);
                Stub finalStub = this.forefront.iterator().next();
                LayoutHelper.finalCheck(this.pSystem, finalStub);
                this.context.logDebug(String.valueOf(this.getClass().getSimpleName()) + ": patternbody build concluded");
                return finalStub;
            }
            catch (RetePatternBuildException ex) {
                ex.setPatternDescription(this.pattern);
                throw ex;
            }
        }

        public List<JoinCandidate<StubHandle>> generateJoinCandidates() {
            ArrayList candidates = new ArrayList();
            int bIndex = 0;
            for (Stub b : this.forefront) {
                int aIndex = 0;
                for (Stub a : this.forefront) {
                    if (aIndex++ >= bIndex) break;
                    candidates.add(new JoinCandidate(a, b));
                }
                ++bIndex;
            }
            return candidates;
        }

        private void admitStub(Stub<StubHandle> stub) throws RetePatternBuildException {
            for (DeferredPConstraint deferred : this.deferredConstraints) {
                if (stub.getAllEnforcedConstraints().contains(deferred) || !deferred.isReadyAt(stub)) continue;
                this.admitStub(deferred.checkOn(stub));
                return;
            }
            this.forefront.add(stub);
        }

        private void doJoin(Stub<StubHandle> primaryStub, Stub<StubHandle> secondaryStub) throws RetePatternBuildException {
            Stub joinedStub = BuildHelper.naturalJoin(this.buildable, primaryStub, secondaryStub);
            this.forefront.remove(primaryStub);
            this.forefront.remove(secondaryStub);
            this.admitStub(joinedStub);
        }
    }
}

