/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteContainment;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectMoveTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetName;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetValue;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.Disconnectable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.IManipulationListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.PredicateEvaluatorNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

public class GlobalModelspaceListener
implements ICoreNotificationListener,
IManipulationListener {
    protected WeakReference<IFramework> framework;
    protected ReteEngine<?> engine;
    protected ReteBoundary<?> boundary;
    protected ReteContainer headContainer;
    protected Map<Object, Set<PredicateEvaluatorNode>> sensitiveTerms;

    public GlobalModelspaceListener(ReteEngine<?> engine, IFramework framework) {
        this.engine = engine;
        this.boundary = engine.getBoundary();
        this.headContainer = engine.getReteNet().getHeadContainer();
        this.sensitiveTerms = new HashMap<Object, Set<PredicateEvaluatorNode>>();
        this.framework = new WeakReference<IFramework>(framework);
        framework.getTopmodel().getNotificationManager().addAllListener((ICoreNotificationListener)this);
        engine.addDisconnectable((Disconnectable)this);
    }

    public synchronized void actionPerformed(ICoreNotificationObject notification) {
        switch (notification.getActionTypeEnum()) {
            case ACTION_SET_NAME: {
                ICoreNotificationObjectSetName n = (ICoreNotificationObjectSetName)notification;
                this.notifyElementChange(n.getElement());
                break;
            }
            case ACTION_SET_VALUE: {
                ICoreNotificationObjectSetValue n1 = (ICoreNotificationObjectSetValue)notification;
                this.notifyElementChange(n1.getEntity());
                break;
            }
            case ACTION_CREATE_INSTANCEOF: {
                ICoreNotificationObjectCreateInstanceOf n2 = (ICoreNotificationObjectCreateInstanceOf)notification;
                IModelElement instance = n2.getInstance();
                if (instance instanceof IEntity) {
                    this.boundary.updateUnary(Direction.INSERT, (Object)instance, (Object)n2.getType());
                } else if (instance instanceof IRelation) {
                    IRelation relation = (IRelation)instance;
                    this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)relation.getFrom(), (Object)relation.getTo(), (Object)n2.getType());
                }
                this.boundary.updateInstantiation(Direction.INSERT, (Object)n2.getType(), (Object)n2.getInstance());
                break;
            }
            case ACTION_DELETE_INSTANCEOF: {
                ICoreNotificationObjectDeleteInstanceOf n3 = (ICoreNotificationObjectDeleteInstanceOf)notification;
                IModelElement instance = n3.getInstance();
                if (instance instanceof IEntity) {
                    this.boundary.updateUnary(Direction.REVOKE, (Object)instance, (Object)n3.getType());
                } else if (instance instanceof IRelation) {
                    IRelation relation = (IRelation)instance;
                    this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)relation.getFrom(), (Object)relation.getTo(), (Object)n3.getType());
                }
                this.boundary.updateInstantiation(Direction.REVOKE, (Object)n3.getType(), (Object)n3.getInstance());
                break;
            }
            case ACTION_CREATE_SUPERTYPEOF: {
                Address superRoot;
                ICoreNotificationObjectCreateSupertypeOf n4 = (ICoreNotificationObjectCreateSupertypeOf)notification;
                IModelElement superElement = n4.getSuper();
                IModelElement subElement = n4.getSub();
                this.boundary.updateGeneralization(Direction.INSERT, (Object)superElement, (Object)subElement);
                if (superElement instanceof IEntity) {
                    Address superRoot2 = this.boundary.getUnaryRoot((Object)superElement);
                    if (superRoot2 == null) break;
                    Address subRoot = this.boundary.accessUnaryRoot((Object)subElement);
                    this.engine.getReteNet().connectRemoteNodes(subRoot, superRoot2, true);
                    break;
                }
                if (!(superElement instanceof IRelation) || (superRoot = this.boundary.getTernaryEdgeRoot((Object)superElement)) == null) break;
                Address subRoot = this.boundary.accessTernaryEdgeRoot((Object)subElement);
                this.engine.getReteNet().connectRemoteNodes(subRoot, superRoot, true);
                break;
            }
            case ACTION_DELETE_SUPERTYPEOF: {
                Address superRoot;
                ICoreNotificationObjectDeleteSupertypeOf n5 = (ICoreNotificationObjectDeleteSupertypeOf)notification;
                IModelElement superElement = n5.getSuper();
                IModelElement subElement = n5.getSub();
                this.boundary.updateGeneralization(Direction.REVOKE, (Object)superElement, (Object)subElement);
                if (superElement instanceof IEntity) {
                    Address superRoot3 = this.boundary.getUnaryRoot((Object)superElement);
                    if (superRoot3 == null) break;
                    Address subRoot = this.boundary.accessUnaryRoot((Object)subElement);
                    this.engine.getReteNet().disconnectRemoteNodes(subRoot, superRoot3, true);
                    break;
                }
                if (!(superElement instanceof IRelation) || (superRoot = this.boundary.getTernaryEdgeRoot((Object)superElement)) == null) break;
                Address subRoot = this.boundary.accessTernaryEdgeRoot((Object)subElement);
                this.engine.getReteNet().disconnectRemoteNodes(subRoot, superRoot, true);
                break;
            }
            case ACTION_CREATE_ENTITY: {
                ICoreNotificationObjectCreateEntity n6 = (ICoreNotificationObjectCreateEntity)notification;
                IEntity entity = n6.getCreated();
                this.boundary.updateUnary(Direction.INSERT, (Object)entity, null);
                this.boundary.updateContainment(Direction.INSERT, (Object)n6.getContainer(), (Object)entity);
                break;
            }
            case ACTION_CREATE_RELATION: {
                ICoreNotificationObjectCreateRelation n7 = (ICoreNotificationObjectCreateRelation)notification;
                IRelation relation = n7.getNewRelation();
                this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)n7.getFrom(), (Object)n7.getTo(), null);
                break;
            }
            case ACTION_MOVE_ELEMENT_TO: {
                ICoreNotificationObjectMoveTo n8 = (ICoreNotificationObjectMoveTo)notification;
                IEntity element = n8.getElement();
                this.boundary.updateContainment(Direction.REVOKE, (Object)n8.getOldContainer(), (Object)element);
                this.boundary.updateContainment(Direction.INSERT, (Object)n8.getNewContainer(), (Object)element);
                this.notifyElementChange(n8.getElement());
                break;
            }
            case ACTION_DELETE_ENTITY: {
                ICoreNotificationObjectDeleteEntity n9 = (ICoreNotificationObjectDeleteEntity)notification;
                IEntity entity = n9.getDeleted();
                this.boundary.updateUnary(Direction.REVOKE, (Object)entity, null);
                break;
            }
            case ACTION_DELETE_RELATION: {
                ICoreNotificationObjectDeleteRelation n10 = (ICoreNotificationObjectDeleteRelation)notification;
                IRelation relation = n10.getDeleted();
                this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)n10.getFrom(), (Object)n10.getTo(), null);
                break;
            }
            case ACTION_DELETE_CONTAINMENT: {
                ICoreNotificationObjectDeleteContainment n11 = (ICoreNotificationObjectDeleteContainment)notification;
                this.boundary.updateContainment(Direction.REVOKE, (Object)n11.getParent(), (Object)n11.getChild());
                break;
            }
            case ACTION_SET_RELATION_FROM: {
                ICoreNotificationObjectSetRelationFrom n12 = (ICoreNotificationObjectSetRelationFrom)notification;
                IRelation relation = n12.getRelation();
                for (IModelElement type : relation.getTypes()) {
                    this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)n12.getOldFrom(), (Object)relation.getTo(), (Object)type);
                    this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)n12.getNewFrom(), (Object)relation.getTo(), (Object)type);
                }
                this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)n12.getOldFrom(), (Object)relation.getTo(), null);
                this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)n12.getNewFrom(), (Object)relation.getTo(), null);
                this.notifyElementChange(relation);
                break;
            }
            case ACTION_SET_RELATION_TO: {
                ICoreNotificationObjectSetRelationTo n13 = (ICoreNotificationObjectSetRelationTo)notification;
                IRelation relation = n13.getRelation();
                for (IModelElement type : relation.getTypes()) {
                    this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)relation.getFrom(), (Object)n13.getOldTo(), (Object)type);
                    this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)relation.getFrom(), (Object)n13.getNewTo(), (Object)type);
                }
                this.boundary.updateTernaryEdge(Direction.REVOKE, (Object)relation, (Object)relation.getFrom(), (Object)n13.getOldTo(), null);
                this.boundary.updateTernaryEdge(Direction.INSERT, (Object)relation, (Object)relation.getFrom(), (Object)n13.getNewTo(), null);
                this.notifyElementChange(relation);
                break;
            }
            case TA_TRANSACTION_END: {
                this.engine.runAfterUpdateCallbacks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyElementChange(Object element) {
        Map<Object, Set<PredicateEvaluatorNode>> map = this.sensitiveTerms;
        synchronized (map) {
            Set<PredicateEvaluatorNode> nodes = this.sensitiveTerms.get(element);
            if (nodes != null) {
                FlatTuple tuple = new FlatTuple(element);
                for (PredicateEvaluatorNode node : nodes) {
                    this.boundary.notifyEvaluator(node.getElementChangeNotifier(), (Tuple)tuple);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSensitiveTerm(Object element, PredicateEvaluatorNode node) {
        Map<Object, Set<PredicateEvaluatorNode>> map = this.sensitiveTerms;
        synchronized (map) {
            Set<PredicateEvaluatorNode> nodes = this.sensitiveTerms.get(element);
            if (nodes == null) {
                nodes = new HashSet<PredicateEvaluatorNode>();
                this.sensitiveTerms.put(element, nodes);
            }
            nodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSensitiveTerm(Object element, PredicateEvaluatorNode node) {
        Map<Object, Set<PredicateEvaluatorNode>> map = this.sensitiveTerms;
        synchronized (map) {
            Set<PredicateEvaluatorNode> nodes = this.sensitiveTerms.get(element);
            nodes.remove(node);
            if (nodes.isEmpty()) {
                this.sensitiveTerms.remove(element);
            }
        }
    }

    public int getListenerCategory() {
        return 0;
    }

    public void disconnect() {
        ((IFramework)this.framework.get()).getTopmodel().getNotificationManager().removeAllListener((ICoreNotificationListener)this);
    }
}

