/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters;

import java.lang.ref.WeakReference;
import java.util.Collection;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GlobalModelspaceListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.IManipulationListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherStringTypedContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;

public abstract class VPMContext<PatternDescription>
implements IPatternMatcherStringTypedContext<PatternDescription>,
IPatternMatcherRuntimeContext<PatternDescription> {
    WeakReference<IFramework> framework;
    IModelManager manager;

    public VPMContext(IFramework framework) {
        this.framework = new WeakReference<IFramework>(framework);
        this.manager = framework.getTopmodel().getModelManager();
    }

    public IPatternMatcherContext.EdgeInterpretation edgeInterpretation() {
        return IPatternMatcherContext.EdgeInterpretation.TERNARY;
    }

    public IPatternMatcherContext.GeneralizationQueryDirection allowedGeneralizationQueryDirection() {
        return IPatternMatcherContext.GeneralizationQueryDirection.BOTH;
    }

    public void enumerateAllUnaries(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        for (IEntity entity : this.manager.getEntities()) {
            crawler.crawl((Object)entity);
        }
    }

    public void enumerateAllBinaryEdges(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllTernaryEdges(IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        for (IRelation relation : this.manager.getRelations()) {
            crawler.crawl((Object)relation);
        }
    }

    public Collection<? extends Object> enumerateDirectSupertypes(Object typeObject) {
        return ((IModelElement)typeObject).getSupertypes();
    }

    public Collection<? extends Object> enumerateDirectSubtypes(Object typeObject) {
        return ((IModelElement)typeObject).getSubtypes();
    }

    public boolean isUnaryType(Object typeObject) {
        return typeObject instanceof IEntity;
    }

    public void enumerateDirectUnaryInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        for (IModelElement modelElement : ((IEntity)typeObject).getInstances()) {
            crawler.crawl((Object)modelElement);
        }
    }

    public void enumerateAllUnaryInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        for (IModelElement modelElement : ((IEntity)typeObject).getAllInstances()) {
            crawler.crawl((Object)modelElement);
        }
    }

    public Collection<? extends Object> enumerateDirectUnarySubtypes(Object typeObject) {
        return ((IEntity)typeObject).getSubtypes();
    }

    public Collection<? extends Object> enumerateDirectUnarySupertypes(Object typeObject) {
        return ((IEntity)typeObject).getSupertypes();
    }

    public boolean isBinaryEdgeType(Object typeObject) {
        return false;
    }

    public void enumerateDirectBinaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public void enumerateAllBinaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Object> enumerateDirectBinaryEdgeSubtypes(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Object> enumerateDirectBinaryEdgeSupertypes(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public boolean isTernaryEdgeType(Object typeObject) {
        return typeObject instanceof IRelation;
    }

    public void enumerateDirectTernaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        for (IModelElement modelElement : ((IRelation)typeObject).getInstances()) {
            crawler.crawl((Object)modelElement);
        }
    }

    public void enumerateAllTernaryEdgeInstances(Object typeObject, IPatternMatcherRuntimeContext.ModelElementCrawler crawler) {
        for (IModelElement modelElement : ((IRelation)typeObject).getAllInstances()) {
            crawler.crawl((Object)modelElement);
        }
    }

    public Collection<? extends Object> enumerateDirectTernaryEdgeSubtypes(Object typeObject) {
        return ((IRelation)typeObject).getSubtypes();
    }

    public Collection<? extends Object> enumerateDirectTernaryEdgeSupertypes(Object typeObject) {
        return ((IRelation)typeObject).getSupertypes();
    }

    public IFramework getFramework() {
        return (IFramework)this.framework.get();
    }

    public boolean inputConstructionEmbargo() {
        return false;
    }

    public Object ternaryEdgeSource(Object relation) {
        return ((IRelation)relation).getFrom();
    }

    public Object ternaryEdgeTarget(Object relation) {
        return ((IRelation)relation).getTo();
    }

    public Object ternaryEdgeSourceType(Object typeObject) {
        IRelation relation = (IRelation)typeObject;
        return relation == null || relation.getIsAnyFrom() ? null : relation.getFrom();
    }

    public Object ternaryEdgeTargetType(Object typeObject) {
        IRelation relation = (IRelation)typeObject;
        return relation == null || relation.getIsAnyTo() ? null : relation.getTo();
    }

    public Object binaryEdgeSourceType(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Object binaryEdgeTargetType(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Object retrieveUnaryType(String fullyQualifiedName) {
        return this.manager.getElementByName(fullyQualifiedName);
    }

    public Object retrieveBinaryEdgeType(String fullyQualifiedName) {
        throw new UnsupportedOperationException();
    }

    public Object retrieveTernaryEdgeType(String fullyQualifiedName) {
        return this.manager.getElementByName(fullyQualifiedName);
    }

    public String retrieveUnaryTypeFQN(Object typeObject) {
        return ((IEntity)typeObject).getFullyQualifiedName();
    }

    public String retrieveBinaryEdgeTypeFQN(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public String retrieveTernaryEdgeTypeFQN(Object typeObject) {
        return ((IRelation)typeObject).getFullyQualifiedName();
    }

    public Object resolveConstant(String fullyQualifiedName) {
        return this.manager.getElementByName(fullyQualifiedName);
    }

    public void enumerateAllUnaryContainments(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        for (IEntity container : ((IFramework)this.framework.get()).getTopmodel().getModelManager().getEntities()) {
            for (IModelElement element : container.getContents()) {
                if (!(element instanceof IEntity)) continue;
                crawler.crawl((Object)container, (Object)element);
            }
        }
    }

    public void enumerateAllInstantiations(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        for (IModelElement type : ((IFramework)this.framework.get()).getTopmodel().getModelManager().getElements()) {
            for (IModelElement instance : type.getInstances()) {
                crawler.crawl((Object)type, (Object)instance);
            }
        }
    }

    public void enumerateAllGeneralizations(IPatternMatcherRuntimeContext.ModelElementPairCrawler crawler) {
        for (IModelElement superType : ((IFramework)this.framework.get()).getTopmodel().getModelManager().getElements()) {
            for (IModelElement subType : superType.getSubtypes()) {
                crawler.crawl((Object)superType, (Object)subType);
            }
        }
    }

    public void modelReadLock() {
        ((IFramework)this.framework.get()).getTopmodel().getModelManager().getLock().readLock().lock();
    }

    public void modelReadUnLock() {
        ((IFramework)this.framework.get()).getTopmodel().getModelManager().getLock().readLock().unlock();
    }

    public IManipulationListener subscribePatternMatcherForUpdates(ReteEngine<PatternDescription> engine) {
        return new GlobalModelspaceListener(engine, (IFramework)this.framework.get());
    }

    public void logDebug(String message) {
        ((IFramework)this.framework.get()).getLogger().debug(message);
    }

    public void logError(String message) {
        ((IFramework)this.framework.get()).getLogger().error(message);
    }

    public void logError(String message, Throwable cause) {
        ((IFramework)this.framework.get()).getLogger().message(1, message, cause);
    }

    public void logWarning(String message) {
        ((IFramework)this.framework.get()).getLogger().warning(message);
    }

    public void logWarning(String message, Throwable cause) {
        ((IFramework)this.framework.get()).getLogger().message(2, message, cause);
    }

    public void finishCoalescing() {
    }

    public void startCoalescing() {
    }
}

