/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.extension;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.viatra2.gtasm.patternmatcher.extension.IGTRuleMatcherFactory;
import org.eclipse.viatra2.gtasm.patternmatcher.extension.IPatternMatcherFactory;
import org.osgi.framework.BundleContext;

public class ViatraGTASMPatternMatcherPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.viatra2.gtasm.interpreter";
    public static final String PATTERN_MATCHER_EXT_ID = "org.eclipse.viatra2.gtasm.patternmatcher.patternmatcher";
    public static final String GT_MATCHER_EXT_ID = "org.eclipse.viatra2.gtasm.patternmatcher.gtrulematcher";
    public static final String INCREMENTAL_PM_FACTORY_ID = "org.eclipse.viatra2.patternmatcher.incremental_rete";
    public static final String LOCAL_PM_FACTORY_ID = "org.eclipse.viatra2.patternmatcher.local_search";
    public static final String DEFAULT_PM_FACTORY_ID = "org.eclipse.viatra2.patternmatcher.local_search";
    public static final String LOCAL_GT_FACTORY_ID = "org.eclipse.viatra2.gtmatcher.local_search";
    public static final String DEFAULT_GT_FACTORY_ID = "org.eclipse.viatra2.gtmatcher.local_search";
    private static ViatraGTASMPatternMatcherPlugin plugin;
    private Map<String, IPatternMatcherFactory> patternMatcherFactories;
    private Map<String, String> patternMatcherIDbyAnnotationName;
    private Map<String, IGTRuleMatcherFactory> gtMatcherFactories;

    public ViatraGTASMPatternMatcherPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ViatraGTASMPatternMatcherPlugin getDefault() {
        return plugin;
    }

    public Map<String, IPatternMatcherFactory> getPatternMatcherFactories() {
        if (this.patternMatcherFactories == null) {
            this.patternMatcherFactories = this.initPatternMatcherFactories();
        }
        return this.patternMatcherFactories;
    }

    public Map<String, String> getPatternMatcherIDbyAnnotationName() {
        if (this.patternMatcherIDbyAnnotationName == null) {
            this.initPatternMatcherFactories();
        }
        return this.patternMatcherIDbyAnnotationName;
    }

    public IPatternMatcherFactory getPatternMatcherFactory(String id) {
        if (this.patternMatcherFactories == null) {
            this.patternMatcherFactories = this.initPatternMatcherFactories();
        }
        return this.patternMatcherFactories.containsKey(id) ? this.patternMatcherFactories.get(id) : this.patternMatcherFactories.get("org.eclipse.viatra2.patternmatcher.local_search");
    }

    private Map<String, IPatternMatcherFactory> initPatternMatcherFactories() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(PATTERN_MATCHER_EXT_ID);
        HashMap<String, IPatternMatcherFactory> r = new HashMap<String, IPatternMatcherFactory>();
        HashMap<String, String> annotMap = new HashMap<String, String>();
        if (poi == null) {
            return r;
        }
        IExtension[] exts = poi.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    Object o = el[j].createExecutableExtension("class");
                    if (o instanceof IPatternMatcherFactory) {
                        String id = el[j].getAttribute("id");
                        r.put(id, (IPatternMatcherFactory)o);
                        String annotationName = el[j].getAttribute("annotation_name");
                        annotMap.put(annotationName, id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        this.patternMatcherIDbyAnnotationName = Collections.unmodifiableMap(annotMap);
        return r;
    }

    public Map<String, IGTRuleMatcherFactory> getgtMatcherFactories() {
        if (this.gtMatcherFactories == null) {
            this.gtMatcherFactories = this.initgtMatcherFactories();
        }
        return this.gtMatcherFactories;
    }

    public IGTRuleMatcherFactory getGTMatcherFactory(String id) {
        if (this.gtMatcherFactories == null) {
            this.gtMatcherFactories = this.initgtMatcherFactories();
        }
        return this.gtMatcherFactories.containsKey(id) ? this.gtMatcherFactories.get(id) : this.gtMatcherFactories.get("org.eclipse.viatra2.gtmatcher.local_search");
    }

    private Map<String, IGTRuleMatcherFactory> initgtMatcherFactories() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(GT_MATCHER_EXT_ID);
        HashMap<String, IGTRuleMatcherFactory> r = new HashMap<String, IGTRuleMatcherFactory>();
        if (poi == null) {
            return r;
        }
        IExtension[] exts = poi.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    Object o = el[j].createExecutableExtension("class");
                    if (o instanceof IGTRuleMatcherFactory) {
                        String id = el[j].getAttribute("id");
                        r.put(id, (IGTRuleMatcherFactory)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return r;
    }
}

