/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.support.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.gtasm.support.helper.LocationOffset;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.Annotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.GTASMElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotationElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;

public class GTASMHelper {
    public static final String NODE_INFORMATION = "node_info";
    public static final String NODE_OFFSET = "node_offset";

    public static Map<String, String> extractLowerCaseRuntimeAnnotation(GTASMElement element, String annotationName) {
        for (RuntimeAnnotation annotation : element.getRuntimeAnnotations()) {
            if (!annotation.getAnnotationName().toLowerCase().equals(annotationName.toLowerCase())) continue;
            return GTASMHelper.processAnnotationParameters(annotation);
        }
        return null;
    }

    public static Map<String, String> processAnnotationParameters(RuntimeAnnotation annotation) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (RuntimeAnnotationElement annotationElement : annotation.getElements()) {
            result.put(annotationElement.getKey().toLowerCase(), annotationElement.getValue());
        }
        return result;
    }

    public static List<RuntimeAnnotation> extractLowerCaseRuntimeAnnotations(GTASMElement element, String annotationName) {
        ArrayList<RuntimeAnnotation> annotations = new ArrayList<RuntimeAnnotation>();
        for (RuntimeAnnotation annotation : element.getRuntimeAnnotations()) {
            if (!annotation.getAnnotationName().toLowerCase().equals(annotationName.toLowerCase())) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public static String extractAnnotation(AnnotatedElement element, String annotationKey) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.getKey().toLowerCase().equals(annotationKey.toLowerCase())) continue;
            return annotation.getValue();
        }
        return "";
    }

    public static GTPattern getPatternByName(Machine machine, String name) {
        EList patterns = machine.getGtPatternDefinitions();
        for (GTPattern pattern : patterns) {
            if (!pattern.getName().equals(name)) continue;
            return pattern;
        }
        return null;
    }

    public static GTRule getGTRuleByName(Machine machine, String name) {
        EList rules = machine.getGtRuleDefinitions();
        for (GTRule rule : rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public static Rule getASMRuleByName(Machine machine, String name) {
        EList rules = machine.getAsmRuleDefinitions();
        for (Rule rule : rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public static LocationOffset getLocation(AnnotatedElement element) {
        String offsetStr = GTASMHelper.extractAnnotation(element, NODE_OFFSET);
        return new LocationOffset(offsetStr);
    }
}

