/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.trigger.engine;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.eclipse.viatra2.gtasm.trigger.engine.TriggerExecutionEngine;

public class TriggerEngineManager
implements IFrameworkListChangedListener {
    private static TriggerEngineManager _instance = new TriggerEngineManager();
    private Map<IFramework, TriggerExecutionEngine> engines = new HashMap<IFramework, TriggerExecutionEngine>();

    public static TriggerEngineManager getInstance() {
        return _instance;
    }

    private TriggerEngineManager() {
        FrameworkManager.getInstance().addFrameworkListChangedListener((IFrameworkListChangedListener)this);
    }

    public TriggerExecutionEngine getTriggerEngine(IFramework fw) {
        if (!this.engines.containsKey(fw)) {
            TriggerExecutionEngine engine = new TriggerExecutionEngine(fw);
            this.engines.put(fw, engine);
            return engine;
        }
        TriggerExecutionEngine engine = this.engines.get(fw);
        return engine;
    }

    public void frameworkAdded(IFramework f) {
    }

    public void frameworkRemoved(IFramework fw) {
        if (this.engines.containsKey(fw)) {
            this.engines.remove(fw);
        }
    }
}

