/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.content;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.viatra2.framework.Framework;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.eclipse.viatra2.frameworkgui.content.FrameworkContainer;
import org.eclipse.viatra2.frameworkgui.content.ITreeObject;
import org.eclipse.viatra2.frameworkgui.content.ITreeParent;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;

public class FrameworkViewContentProvider
implements ITreeContentProvider,
IFrameworkListChangedListener {
    private FrameworkTreeView iFT;
    private Map<IFramework, FrameworkContainer> frameworkContainers;

    public FrameworkViewContentProvider(FrameworkTreeView part) {
        this.iFT = part;
        this.frameworkContainers = new HashMap<IFramework, FrameworkContainer>();
        this.refreshFrameworks();
        FrameworkManager.getInstance().addFrameworkListChangedListener((IFrameworkListChangedListener)this);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        FrameworkManager.getInstance().removeFrameworkListChangedListener((IFrameworkListChangedListener)this);
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object[] getChildren(Object parent) {
        if (parent.equals(this.iFT.getViewSite())) {
            return this.frameworkContainers.values().toArray();
        }
        if (parent instanceof ITreeParent) {
            return ((ITreeParent)parent).getChildren().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object child) {
        if (child instanceof ITreeObject) {
            return ((ITreeObject)child).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ITreeParent) {
            return ((ITreeParent)parent).hasChildren();
        }
        return false;
    }

    public void frameworkAdded(final IFramework f) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FrameworkContainer c = new FrameworkContainer(f, FrameworkViewContentProvider.this.iFT);
                FrameworkViewContentProvider.this.frameworkContainers.put(f, c);
                FrameworkViewContentProvider.this.iFT.refreshViewer(null);
                try {
                    FrameworkViewContentProvider.this.iFT.getViewSite().getPage().showView("org.eclipse.viatra2.gui.codebufferview");
                }
                catch (PartInitException e) {
                    f.getLogger().fatal(e.getMessage());
                }
            }
        });
    }

    public void frameworkRemoved(final IFramework f) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FrameworkContainer c = (FrameworkContainer)FrameworkViewContentProvider.this.frameworkContainers.get(f);
                if (c != null) {
                    c.dispose();
                }
                FrameworkViewContentProvider.this.frameworkContainers.remove(f);
                FrameworkViewContentProvider.this.iFT.refreshViewer(null);
            }
        });
    }

    private void refreshFrameworks() {
        String[] fws = this.iFT.getFrameWorkManager().getAllFrameWorks();
        int i = 0;
        while (i < fws.length) {
            Framework fw = this.iFT.getFrameWorkManager().getFramework(fws[i]);
            FrameworkContainer c = new FrameworkContainer((IFramework)fw, this.iFT);
            this.frameworkContainers.put((IFramework)fw, c);
            ++i;
        }
    }
}

