/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.code;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.viatra2.buffers.BufferStore;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.framework.Framework;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.frameworkgui.views.code.CodeBufferView;

public class SaveAllBuffersAction
extends Action {
    CodeBufferView cbv;

    public SaveAllBuffersAction(CodeBufferView v) {
        this.cbv = v;
        this.setToolTipText("Save the content of all buffers to a directory in the workspace");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setText("Save outputs");
    }

    public void run() {
        ContainerSelectionDialog dd = new ContainerSelectionDialog(this.cbv.getViewSite().getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Select destination folder:");
        dd.setBlockOnOpen(true);
        dd.setTitle("Select folder to save buffers to");
        Framework fw = FrameworkManager.getInstance().getFramework(this.cbv.getCurrentOuterPage().frameworkId);
        if (BufferStore.getAllCoreBuffers((IModelSpace)fw.getTopmodel()) != null && dd.open() == 0) {
            try {
                Object[] dirs;
                Object[] objectArray = dirs = dd.getResult();
                int n = dirs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object _p = objectArray[n2];
                    IPath p = (IPath)_p;
                    for (Map.Entry buf : BufferStore.getAllCoreBuffers((IModelSpace)fw.getTopmodel())) {
                        String fileName = ((String)buf.getKey()).replaceFirst("core://", "");
                        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(p.append("/" + fileName));
                        FileWriter wr = new FileWriter(new File(ifile.getLocation().toOSString()));
                        try {
                            wr.write(((StringWriter)buf.getValue()).getBuffer().toString());
                        }
                        finally {
                            wr.flush();
                            wr.close();
                        }
                    }
                    ++n2;
                }
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                fw.getLogger().fatal(e.getMessage());
            }
            catch (CoreException e) {
                fw.getLogger().fatal(e.getMessage());
            }
        }
    }
}

