/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.xform;

import java.util.List;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.xform.AbstractRunnerCommand;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;

public class RunRuleUndoable
extends AbstractRunnerCommand
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        if (parameters.size() != 2) {
            fw.getLogger().error("[RunRuleUndoable] Wrong number of parameters supplied.");
            return;
        }
        String ruleFQN = parameters.get(0);
        if (ruleFQN.indexOf(".") < 0) {
            fw.getLogger().error("[RunRuleUndoable] rule FQN does not contain at least one dot (.)");
            return;
        }
        String ruleName = ruleFQN.substring(ruleFQN.lastIndexOf(".") + 1);
        if (ruleName.length() < 1) {
            fw.getLogger().error("[RunRuleUndoable] rule name empty.");
            return;
        }
        String machineFQN = ruleFQN.substring(0, ruleFQN.lastIndexOf("."));
        Machine m = (Machine)fw.getMachineByFQN(machineFQN);
        if (m == null) {
            fw.getLogger().error("[RunRuleUndoable] machine " + machineFQN + " not found.");
            return;
        }
        Rule entrypoint = null;
        for (Rule r : m.getAsmRuleDefinitions()) {
            if (!r.getName().equals(ruleName)) continue;
            entrypoint = r;
            break;
        }
        this.commenceRunning(fw, entrypoint, parameters.get(1), ruleName, true);
    }

    @Override
    public String getCommandSignature() {
        return "runruleundoable(ruleFQN,parameterMappings)";
    }

    @Override
    public String getDescription() {
        return "Executes a GTASM Rule in an undoable VIATRA2 transaction.";
    }

    @Override
    public String getHelpText() {
        return "Use runruleUndoable(<<rule fqn>>,<<parametermapping>>) to execute a GTASM rule in an undoable transaction.\nParameter mappings take the following syntax: <<parametername=value>> and are separated by ; characters.\nExample: runrule(helloworld.sayhello, target=John;message=Hello)";
    }
}

