/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.imports.vtml;

import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.imports.vtml.ASTBuilder;
import org.eclipse.viatra2.imports.vtml.ElementDefinition;
import org.eclipse.viatra2.imports.vtml.VTMLMetaModelHelper;

public class RelationDefinition
extends ElementDefinition {
    IRelation element = null;
    String name;
    String namespace;
    String defns;
    String type;
    String source;
    String target;
    IModelElement tar;
    IModelElement src;
    IModelElement typ;
    IEntity ns;
    public boolean isNativ = false;
    RelationDefinition _type = null;
    ElementDefinition _source = null;
    ElementDefinition _target = null;
    String tmpName;
    IRelation me;
    IEntity tmp;
    boolean amIFun = false;
    IModelManager mm;

    @Override
    public IModelElement getElement() {
        if (this.element == null) {
            this.elemGen(VTMLMetaModelHelper.getInstance().getMSpace());
        }
        return this.element;
    }

    public String toString() {
        return "relation name : " + this.name + " type : " + this.type + " src : " + this.source + " trg: " + this.target + " namespace: " + this.namespace;
    }

    public RelationDefinition(IRelation r) {
        this.defns = "";
        this.name = r.getName();
        this.namespace = r.getNamespace().getFullyQualifiedName();
        this.source = r.getFrom().getFullyQualifiedName();
        this.target = r.getTo().getFullyQualifiedName();
        this.element = r;
        this.type = null;
        this.isNativ = true;
    }

    public RelationDefinition(int l, String ns, String n, String t, String s, String tar) {
        this.name = n;
        if (this.name.indexOf(".") > 0) {
            this.name = this.name.substring(this.name.lastIndexOf(".") + 1);
        }
        this.namespace = ns;
        this.defns = ns;
        this.type = t;
        this.source = s;
        this.target = tar;
        this.setLine(l);
        this.isNativ = false;
    }

    @Override
    public boolean checkDefintion(ASTBuilder ab, IModelSpace m) {
        Object tmp = null;
        if (!this.isNativ) {
            this._type = ab.getRelationWithLookup(this.defns, this.type);
            if (this._type == null && !this.type.equals("relation")) {
                ab.log.error("type " + this.type + " for relation " + this.name + " not found. Error in line " + this.getLine());
                return false;
            }
            this._source = ab.getElementWithLookup(this.defns, this.source);
            if (this._source == null) {
                ab.log.error("Source " + this.source + " for relation " + this.name + " not found. Error in line " + this.getLine());
                return false;
            }
            this.source = tmp;
            this._target = ab.getElementWithLookup(this.defns, this.target);
            if (this._target == null) {
                ab.log.error("Target " + this.target + " for relation " + this.name + " not found. Error in line " + this.getLine());
                return false;
            }
            this.target = tmp;
            if (this._target == this || this._source == this) {
                ab.log.error("Relation cannot start or end in itself. Error in line " + this.getLine());
                return false;
            }
        }
        for (RelationDefinition r : this.relations) {
            boolean btm = r.checkDefintion(ab, m);
            if (btm) continue;
            return false;
        }
        return true;
    }

    @Override
    public void resolveReferences(ASTBuilder ab) throws VPMCoreException {
    }

    @Override
    public String getFQN() {
        return String.valueOf(this.namespace) + "." + this.name;
    }

    @Override
    public void updateModelspace(ASTBuilder ab, IModelSpace m) throws VPMCoreException {
        this.elemGen(m);
        for (RelationDefinition r : this.relations) {
            r.updateModelspace(ab, m);
        }
    }

    @Override
    public void generateElements(ASTBuilder ab, IModelSpace m, IEntity temp) throws VPMCoreException {
    }

    public void elemGen(IModelSpace m) {
        if (this.element == null) {
            try {
                this.mm = m.getModelManager();
                this.element = this.mm.newRelation(this.name, this._source.getElement(), this._target.getElement());
                if (this._type != null) {
                    this.mm.newInstanceOf(this._type.getElement(), (IModelElement)this.element);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        if (this.isNativ) {
            return this.element.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        if (this.isNativ) {
            if (this.element.getFrom().getNamespace() != null) {
                return this.element.getFrom().getNamespace().getFullyQualifiedName();
            }
            return "";
        }
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getSource() {
        if (this.isNativ) {
            return this.element.getFrom().getName();
        }
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

