/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.imports.vtml;

import java.util.Stack;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.imports.vtml.ASTBuilder;
import org.eclipse.viatra2.logger.Logger;

public class VTMLMetaModelHelper {
    private static VTMLMetaModelHelper instance;
    private static Logger log;
    private IModelSpace modsp;
    private IModelManager mm;
    Stack conts = new Stack();
    IEntity machine;
    ASTBuilder ab;

    static {
        log = null;
    }

    public IModelSpace getMSpace() {
        return this.modsp;
    }

    public void addContainer(IEntity e) {
        this.conts.push(e);
    }

    public IEntity currentContainer() {
        return (IEntity)this.conts.peek();
    }

    public IEntity removeContainer() {
        return (IEntity)this.conts.pop();
    }

    public static VTMLMetaModelHelper getInstance() {
        if (instance == null) {
            instance = new VTMLMetaModelHelper();
        }
        if (log == null) {
            return null;
        }
        return instance;
    }

    private VTMLMetaModelHelper() {
    }

    public static void init(Logger l, IModelSpace ms, ASTBuilder a) throws VPMRuntimeException {
        log = l;
        VTMLMetaModelHelper.getInstance().modsp = ms;
        VTMLMetaModelHelper.getInstance().mm = ms.getModelManager();
        VTMLMetaModelHelper.getInstance().ab = a;
        VTMLMetaModelHelper.getInstance().loadMetaModel();
    }

    private IEntity ent(String fqn) {
        IEntity ret = this.mm.getEntityByName(fqn);
        if (ret == null) {
            throw new RuntimeException("invalid model");
        }
        return ret;
    }

    private IRelation rel(String fqn) {
        IRelation ret = this.mm.getRelationByName(fqn);
        if (ret == null) {
            throw new RuntimeException("invalid model");
        }
        return ret;
    }

    public static void deleteInstance() {
        instance = null;
    }

    private void loadMetaModel() throws VPMRuntimeException {
    }

    public ASTBuilder getASTBuilder() {
        return this.ab;
    }
}

