/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.loader;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.errors.info.ErrorInformation;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.loaders.Loader;
import org.eclipse.viatra2.logger.Logger;
import org.eclipse.viatra2.lpgparser.loader.VTCLParseController;
import org.eclipse.viatra2.lpgparser.loader.VTCLParserManager;

public class LPGVTCLLoader
implements Loader {
    public Object process(InputStream f, IFramework fw) throws VPMRuntimeException {
        throw new VPMRuntimeException("The VTCL loader does not support loading from an InputStream.");
    }

    public Object processFile(String fileName, IFramework framework) throws VPMRuntimeException {
        Machine machine = this.loadMachineFromFile(fileName, framework);
        return machine;
    }

    private Machine loadMachineFromFile(String fileName, IFramework framework) throws VPMRuntimeException {
        VTCLParserManager parserManager = (VTCLParserManager)framework.getVTCLParserManager();
        VTCLParseController parseController = parserManager.lookupAndCreateParseController(fileName);
        Logger log = framework.getLogger();
        Machine m = null;
        try {
            parseController.parseAndBuild();
            boolean hasErrors = false;
            boolean hasWarnings = false;
            if (parseController.getErrors() != null && parseController.getErrors().size() > 0) {
                Iterator<ErrorInformation> it1 = parseController.getErrors().iterator();
                while (!hasErrors && it1.hasNext()) {
                    ErrorInformation error = it1.next();
                    if (error.getErrorSeverity().compareTo((Enum)ErrorInformation.ErrorSeverity.ERROR) == 0) {
                        hasErrors = true;
                        continue;
                    }
                    if (error.getErrorSeverity().compareTo((Enum)ErrorInformation.ErrorSeverity.WARNING) != 0) continue;
                    hasWarnings = true;
                }
                List<ErrorInformation> errorList = parseController.getErrors();
                int i = 0;
                while (i < errorList.size()) {
                    ErrorInformation errorInfo = errorList.get(i);
                    String errorMsg = errorInfo.getMessageWithLocation();
                    ErrorInformation.ErrorSeverity errorSeverity = errorInfo.getErrorSeverity();
                    switch (errorSeverity) {
                        case ERROR: {
                            log.error(errorMsg);
                            break;
                        }
                        case WARNING: {
                            log.warning(errorMsg);
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (!hasErrors) {
                m = parseController.getMachine();
                framework.addMachine(m.getFqn(), (Object)m);
                String msg = hasWarnings ? "Parsing completed, but there are some warnings in the Error Log. Transformation " + parseController.getMachine().getName() + " can now be executed in the VIATRA Frameworks view" : "Parsing completed successfully. Transformation " + parseController.getMachine().getName() + " can now be executed in the VIATRA Frameworks view";
                log.info(msg);
            }
        }
        catch (Exception e) {
            throw new VPMRuntimeException("Error during the loading of the VTCL file: " + e.getMessage(), (Throwable)e);
        }
        return m;
    }
}

