/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.typechecker;

import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.And;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Division;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Equals;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.GreaterThan;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.GreaterThanOrEqualTo;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.LessThan;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.LessThanOrEqualTo;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Minus;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Multiply;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Not;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.NotEquals;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Or;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Plus;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Remainder;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToBoolean;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToDouble;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToInt;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToModelElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToMultiplicity;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToString;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.XOr;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Aggregate;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.ElementReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.FullyQualifiedName;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Inverse;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Multiplicity;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Name;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Source;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Target;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Value;

public class TermTypeChecker {
    private static ValueKind undef = ValueKind.UNDEF_LITERAL;
    private static ValueKind bool = ValueKind.BOOLEAN_LITERAL;
    private static ValueKind str = ValueKind.STRING_LITERAL;
    private static ValueKind intg = ValueKind.INTEGER_LITERAL;
    private static ValueKind dbl = ValueKind.DOUBLE_LITERAL;
    private static ValueKind model = ValueKind.MODELELEMENT_LITERAL;
    private static ValueKind multi = ValueKind.MULTIPLICITY_LITERAL;
    private static ValueKind error = ValueKind.ERROR_LITERAL;
    private static final ValueKind[][] logicalOperator = new ValueKind[][]{{bool, bool, error, error, error, bool, error, undef}, {bool, bool, error, error, error, bool, error, undef}, {error, error, error, error, error, error, error, undef}, {error, error, error, error, error, error, error, undef}, {error, error, error, error, error, error, error, undef}, {bool, bool, error, error, error, error, error, undef}, {undef, error, error, error, error, error, multi, undef}, {undef, undef, undef, undef, undef, undef, undef, undef}};
    private static final ValueKind[][] equalNotEqualOperator = new ValueKind[][]{{bool, bool, bool, bool, bool, bool, bool, undef}, {bool, bool, error, error, error, bool, error, undef}, {bool, error, bool, error, error, bool, error, undef}, {bool, error, error, bool, bool, bool, error, undef}, {bool, error, error, bool, bool, bool, error, undef}, {bool, bool, bool, bool, bool, bool, error, undef}, {bool, error, error, error, error, error, bool, undef}, {undef, undef, undef, undef, undef, undef, undef, undef}};
    private static final ValueKind[][] relationalOperator = new ValueKind[][]{{bool, error, error, bool, bool, bool, bool, undef}, {error, error, error, error, error, error, error, undef}, {error, error, error, error, error, error, error, undef}, {bool, error, error, bool, bool, bool, error, undef}, {bool, error, error, bool, bool, bool, error, undef}, {bool, error, error, bool, bool, bool, error, undef}, {bool, error, error, error, error, error, bool, undef}, {undef, undef, undef, undef, undef, undef, undef, undef}};
    private static final ValueKind[][] addOperator = new ValueKind[][]{{undef, undef, str, undef, undef, undef, undef, undef}, {undef, error, str, error, error, error, error, undef}, {str, str, str, str, str, str, str, str}, {undef, error, str, intg, dbl, error, error, undef}, {undef, error, str, dbl, dbl, error, error, undef}, {undef, error, str, error, error, model, error, undef}, {undef, error, str, error, error, error, error, undef}, {undef, undef, str, undef, undef, undef, undef, undef}};
    private static final ValueKind[][] subtractMultiplyDivideOperator = new ValueKind[][]{{undef, undef, undef, undef, undef, undef, undef, undef}, {undef, error, error, error, error, error, error, undef}, {undef, error, error, error, error, error, error, undef}, {undef, error, error, intg, dbl, error, error, undef}, {undef, error, error, dbl, dbl, error, error, undef}, {undef, error, error, error, error, model, error, undef}, {undef, error, error, error, error, error, error, undef}, {undef, undef, undef, undef, undef, undef, undef, undef}};
    private static final ValueKind[][] remainderOperator = new ValueKind[][]{{undef, undef, undef, undef, undef, undef, undef, undef}, {undef, error, error, error, error, error, error, undef}, {undef, error, error, error, error, error, error, undef}, {undef, error, error, intg, error, error, error, undef}, {undef, error, error, error, error, error, error, undef}, {undef, error, error, error, error, error, error, undef}, {undef, error, error, error, error, error, error, undef}, {undef, undef, undef, undef, undef, undef, undef, undef}};
    private static final ValueKind[] notOperator = new ValueKind[]{undef, bool, error, error, error, error, error, undef};
    private static final ValueKind[] minusOperator = new ValueKind[]{undef, error, error, intg, dbl, error, error, undef};
    private static final ValueKind[] aggregate = new ValueKind[]{bool, error, error, error, error, bool, error, undef};
    private static final ValueKind[] source = new ValueKind[]{model, error, error, error, error, model, error, undef};
    private static final ValueKind[] target = new ValueKind[]{model, error, error, error, error, model, error, undef};
    private static final ValueKind[] ref = new ValueKind[]{model, error, model, error, error, error, error, undef};
    private static final ValueKind[] fqn = new ValueKind[]{str, error, error, error, error, str, error, undef};
    private static final ValueKind[] name = new ValueKind[]{str, error, error, error, error, str, error, undef};
    private static final ValueKind[] value = new ValueKind[]{str, error, error, error, error, str, error, undef};
    private static final ValueKind[] inverse = new ValueKind[]{model, error, error, error, error, model, error, undef};
    private static final ValueKind[] multiplicity = new ValueKind[]{multi, error, error, error, error, multi, error, undef};
    private static final ValueKind[] toString = new ValueKind[]{str, str, str, str, str, str, str, str};
    private static final ValueKind[] toInt = new ValueKind[]{intg, error, intg, intg, intg, error, error, undef};
    private static final ValueKind[] toDouble = new ValueKind[]{dbl, error, dbl, dbl, dbl, error, error, undef};
    private static final ValueKind[] toBoolean = new ValueKind[]{bool, bool, bool, bool, bool, error, error, undef};
    private static final ValueKind[] toMultiplicity = new ValueKind[]{multi, error, multi, error, error, error, multi, undef};

    public static final ValueKind typeCheck(Term term, ValueKind operand) {
        if (term instanceof Not) {
            return notOperator[operand.getValue()];
        }
        if (term instanceof Minus) {
            return minusOperator[operand.getValue()];
        }
        if (term instanceof Aggregate) {
            return aggregate[operand.getValue()];
        }
        if (term instanceof Source) {
            return source[operand.getValue()];
        }
        if (term instanceof Target) {
            return target[operand.getValue()];
        }
        if (term instanceof ElementReference) {
            return ref[operand.getValue()];
        }
        if (term instanceof FullyQualifiedName) {
            return fqn[operand.getValue()];
        }
        if (term instanceof Name) {
            return name[operand.getValue()];
        }
        if (term instanceof Value) {
            return value[operand.getValue()];
        }
        if (term instanceof Inverse) {
            return inverse[operand.getValue()];
        }
        if (term instanceof Multiplicity) {
            return multiplicity[operand.getValue()];
        }
        if (term instanceof ToString) {
            return toString[operand.getValue()];
        }
        if (term instanceof ToInt) {
            return toInt[operand.getValue()];
        }
        if (term instanceof ToDouble) {
            return toDouble[operand.getValue()];
        }
        if (term instanceof ToBoolean) {
            return toBoolean[operand.getValue()];
        }
        if (term instanceof ToMultiplicity) {
            return toMultiplicity[operand.getValue()];
        }
        return ValueKind.ERROR_LITERAL;
    }

    public static final ValueKind typeCheck(Term term, ValueKind left, ValueKind right) {
        if (term instanceof Or) {
            return logicalOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof XOr) {
            return logicalOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof And) {
            return logicalOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof Equals) {
            return equalNotEqualOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof NotEquals) {
            return equalNotEqualOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof GreaterThan) {
            return relationalOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof LessThan) {
            return relationalOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof GreaterThanOrEqualTo) {
            return relationalOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof LessThanOrEqualTo) {
            return relationalOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof Plus) {
            return addOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof Minus) {
            return subtractMultiplyDivideOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof Multiply) {
            return subtractMultiplyDivideOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof Division) {
            return subtractMultiplyDivideOperator[left.getValue()][right.getValue()];
        }
        if (term instanceof Remainder) {
            return remainderOperator[left.getValue()][right.getValue()];
        }
        return ValueKind.ERROR_LITERAL;
    }

    public static final String getOperationString(Term term) {
        if (term instanceof Not) {
            return "!";
        }
        if (term instanceof Minus) {
            return "-";
        }
        if (term instanceof Aggregate) {
            return "aggregation";
        }
        if (term instanceof Source) {
            return "source";
        }
        if (term instanceof Target) {
            return "target";
        }
        if (term instanceof ElementReference) {
            return "ref";
        }
        if (term instanceof FullyQualifiedName) {
            return "fqn";
        }
        if (term instanceof Name) {
            return "name";
        }
        if (term instanceof Value) {
            return "value";
        }
        if (term instanceof Inverse) {
            return "inverse";
        }
        if (term instanceof Multiplicity) {
            return "multiplicity";
        }
        if (term instanceof ToString) {
            return "toString";
        }
        if (term instanceof ToInt) {
            return "toInteger";
        }
        if (term instanceof ToDouble) {
            return "toDouble";
        }
        if (term instanceof ToBoolean) {
            return "toBoolean";
        }
        if (term instanceof ToModelElement) {
            return "toModelElement";
        }
        if (term instanceof ToMultiplicity) {
            return "toMultiplicity";
        }
        if (term instanceof Or) {
            return "||";
        }
        if (term instanceof XOr) {
            return "xor";
        }
        if (term instanceof And) {
            return "&&";
        }
        if (term instanceof Equals) {
            return "==";
        }
        if (term instanceof NotEquals) {
            return "!=";
        }
        if (term instanceof GreaterThan) {
            return ">";
        }
        if (term instanceof LessThan) {
            return "<";
        }
        if (term instanceof GreaterThanOrEqualTo) {
            return ">=";
        }
        if (term instanceof LessThanOrEqualTo) {
            return "<=";
        }
        if (term instanceof Plus) {
            return "+";
        }
        if (term instanceof Minus) {
            return "-";
        }
        if (term instanceof Multiply) {
            return "*";
        }
        if (term instanceof Division) {
            return "/";
        }
        if (term instanceof Remainder) {
            return "%";
        }
        return "unknown";
    }
}

