/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public abstract class ViatraColoredLabelProvider
extends LabelProvider {
    protected Color ENTITY_BG;
    protected Color ENTITY_HL;
    protected Color ENTITY_FG;
    protected Color ENTITY_BO;
    protected Color ENTITY_BOHL;
    protected Color RELATION_BG;
    protected Color RELATION_HL;
    protected Color RELATION_FG;
    protected Color RELATION_BO;
    protected Color RELATION_BOHL;
    protected Color PATTERN_BG;
    protected Color PATTERN_HL;
    protected Color PATTERN_FG;
    protected Color PATTERN_BO;
    protected Color PATTERN_BOHL;
    protected Color ARC;
    protected Color ARC_HL;
    protected Color PARAM;
    protected Color PARAM_HL;
    private ITheme theme;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ViatraColoredLabelProvider.this.reloadColors();
        }
    };

    public ViatraColoredLabelProvider() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager.getCurrentTheme();
        this.loadTheme(currentTheme);
    }

    public void loadTheme(ITheme theme) {
        if (this.theme != null) {
            this.theme.removePropertyChangeListener(this.listener);
        }
        this.theme = theme;
        this.theme.addPropertyChangeListener(this.listener);
        this.reloadColors();
    }

    public void reloadColors() {
        ColorRegistry colorRegistry = this.theme.getColorRegistry();
        this.ENTITY_BG = colorRegistry.get("org.eclipse.viatra2.visualisation.entity.background");
        this.ENTITY_HL = colorRegistry.get("org.eclipse.viatra2.visualisation.entity.highlight");
        this.ENTITY_FG = colorRegistry.get("org.eclipse.viatra2.visualisation.entity.foreground");
        this.ENTITY_BO = colorRegistry.get("org.eclipse.viatra2.visualisation.entity.border");
        this.ENTITY_BOHL = colorRegistry.get("org.eclipse.viatra2.visualisation.entity.borderhighlight");
        this.RELATION_BG = colorRegistry.get("org.eclipse.viatra2.visualisation.relation.background");
        this.RELATION_HL = colorRegistry.get("org.eclipse.viatra2.visualisation.relation.highlight");
        this.RELATION_FG = colorRegistry.get("org.eclipse.viatra2.visualisation.relation.foreground");
        this.RELATION_BO = colorRegistry.get("org.eclipse.viatra2.visualisation.relation.border");
        this.RELATION_BOHL = colorRegistry.get("org.eclipse.viatra2.visualisation.relation.borderhighlight");
        this.PATTERN_BG = colorRegistry.get("org.eclipse.viatra2.visualisation.pattern.background");
        this.PATTERN_HL = colorRegistry.get("org.eclipse.viatra2.visualisation.pattern.highlight");
        this.PATTERN_FG = colorRegistry.get("org.eclipse.viatra2.visualisation.pattern.foreground");
        this.PATTERN_BO = colorRegistry.get("org.eclipse.viatra2.visualisation.pattern.border");
        this.PATTERN_BOHL = colorRegistry.get("org.eclipse.viatra2.visualisation.pattern.borderhighlight");
        this.ARC = colorRegistry.get("org.eclipse.viatra2.visualisation.arc");
        this.ARC_HL = colorRegistry.get("org.eclipse.viatra2.visualisation.archighlight");
        this.PARAM = colorRegistry.get("org.eclipse.viatra2.visualisation.parameter");
        this.PARAM_HL = colorRegistry.get("org.eclipse.viatra2.visualisation.parameterhighlight");
    }

    public void dispose() {
        if (this.theme != null) {
            this.theme.removePropertyChangeListener(this.listener);
        }
        super.dispose();
    }
}

