/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.color;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemePreview;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.visualisation.color.PreviewEntity;
import org.eclipse.viatra2.visualisation.color.PreviewRelation;
import org.eclipse.viatra2.visualisation.modelspace.ModelSpaceGraphViewer;
import org.eclipse.viatra2.visualisation.modelspace.datasource.GraphArc;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;

public class ColorPreviewFrame
implements IThemePreview {
    ModelSpaceGraphViewer gv;
    ITheme theme;
    IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ColorPreviewFrame.this.reloadTheme();
        }
    };

    public void createControl(Composite parent, ITheme currentTheme) {
        this.theme = currentTheme;
        currentTheme.addPropertyChangeListener(this.listener);
        this.gv = new ModelSpaceGraphViewer(parent, 0);
        this.gv.setLayoutAlgorithm((LayoutAlgorithm)new RadialLayoutAlgorithm(3), true);
        this.gv.loadTheme(currentTheme);
        this.gv.setConnectionStyle(2);
        this.gv.setContentProvider((IContentProvider)new IGraphEntityRelationshipContentProvider(){
            PreviewEntity entity1 = new PreviewEntity("Entity1");
            PreviewEntity entity2 = new PreviewEntity("Entity2");
            PreviewRelation relation = new PreviewRelation("Relation");

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{this.entity1, this.entity2, this.relation};
            }

            public Object[] getRelationships(Object source, Object dest) {
                if (!(source.equals(this.entity1) && dest.equals(this.relation) || source.equals(this.relation) && dest.equals(this.entity2))) {
                    return null;
                }
                GraphArc arc = new GraphArc((IModelElement)source, (IModelElement)dest, "relation");
                return new Object[]{arc};
            }
        });
        this.gv.setInput(null);
    }

    void reloadTheme() {
        this.gv.refreshTheme();
        this.gv.setInput(null);
    }

    public void dispose() {
        this.theme.removePropertyChangeListener(this.listener);
    }
}

