/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.common.filters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;

public abstract class TypeBasedFilter
extends ViewerFilter {
    protected static final List<String> allowedTypeIDs = new ArrayList<String>();
    protected static final List<String> disallowedTypeIDs = new ArrayList<String>();
    int modelSpaceHash;

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            IModelSpace ms = modelElement.getModelSpace();
            IModelManager mm = ms.getModelManager();
            if (!allowedTypeIDs.isEmpty() && ms.hashCode() != this.modelSpaceHash) {
                this.modelSpaceHash = ms.hashCode();
                allowedTypeIDs.clear();
            }
            if (allowedTypeIDs.isEmpty()) {
                this.fillAllowedTypeIDs(mm);
            }
            if (!disallowedTypeIDs.isEmpty() && ms.hashCode() != this.modelSpaceHash) {
                this.modelSpaceHash = ms.hashCode();
                allowedTypeIDs.clear();
            }
            if (disallowedTypeIDs.isEmpty()) {
                this.fillDisallowedTypeIDs(mm);
            }
            if (!allowedTypeIDs.isEmpty()) {
                for (String typeId : allowedTypeIDs) {
                    IModelElement type = mm.getElementByID(typeId);
                    if (!modelElement.isInstanceOf(type)) continue;
                    return true;
                }
                return false;
            }
            if (!disallowedTypeIDs.isEmpty()) {
                for (String typeId : disallowedTypeIDs) {
                    IModelElement type = mm.getElementByID(typeId);
                    if (!modelElement.isInstanceOf(type)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    protected abstract void fillAllowedTypeIDs(IModelManager var1);

    protected abstract void fillDisallowedTypeIDs(IModelManager var1);
}

