/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.common.labelproviders;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.visualisation.modelspace.datasource.ModelSpaceLabelProvider;

public class SmartLabelProvider
extends ModelSpaceLabelProvider {
    FontRegistry fontRegistry = new FontRegistry(Display.getDefault());

    public SmartLabelProvider() {
        this.fontRegistry.put("default", new FontData[]{new FontData("Sans", 9, 1)});
        this.fontRegistry.put("code", new FontData[]{new FontData("Sans", 9, 0)});
    }

    protected static String getTypesAsString(IModelElement element) {
        StringBuffer r = new StringBuffer();
        for (IModelElement type : element.getTypes()) {
            if (r.length() > 0) {
                r.append(",");
            }
            r.append(type.getName());
        }
        return r.toString();
    }

    protected static String getShortText2(String s) {
        return s;
    }

    @Override
    public String getText(Object element) {
        if (element instanceof IModelElement) {
            String typeStr;
            IEntity ent;
            IModelElement me = (IModelElement)element;
            String nameStr = "";
            if (!me.getName().startsWith("uN")) {
                nameStr = String.valueOf(nameStr) + me.getName();
            }
            if (element instanceof IEntity && (ent = (IEntity)element).getValue() != null && ent.getValue().length() > 0) {
                nameStr = String.valueOf(nameStr) + " {" + ent.getValue() + "}";
            }
            if ((typeStr = SmartLabelProvider.getShortText2(SmartLabelProvider.getTypesAsString(me))).length() > 0) {
                return String.valueOf(nameStr) + ": " + typeStr;
            }
            return nameStr;
        }
        return super.getText(element);
    }

    @Override
    public boolean fisheyeNode(Object entity) {
        return false;
    }

    @Override
    public IFigure getTooltip(Object entity) {
        if (entity instanceof IModelElement) {
            IModelElement me = (IModelElement)entity;
            FlowPage fp = new FlowPage();
            TextFlow nameTf = new TextFlow();
            nameTf.setFont(this.fontRegistry.get("default"));
            TextFlow infoTf = new TextFlow();
            infoTf.setFont(this.fontRegistry.get("code"));
            nameTf.setText(me.getName());
            String info = "\n";
            info = String.valueOf(info) + "FQN: " + me.getFullyQualifiedName() + "\n";
            info = String.valueOf(info) + "Namespace: " + me.getNamespace().getName() + "\n";
            info = String.valueOf(info) + "Types: " + SmartLabelProvider.getTypesAsString(me) + "\n";
            if (me instanceof IEntity) {
                info = String.valueOf(info) + "Value: " + ((IEntity)me).getValue() + "\n";
            }
            info = String.valueOf(info) + "Comments: " + me.getViewInfo() + "\n";
            infoTf.setText(info);
            fp.add((IFigure)nameTf);
            fp.add((IFigure)infoTf);
            return fp;
        }
        return null;
    }
}

