/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.common.labelproviders.internal;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.viatra2.visualisation.common.labelproviders.internal.DashedBorder;
import org.eclipse.viatra2.visualisation.common.labelproviders.internal.LocalCoordinatePanel;

public abstract class ShapeCenteringFigure
extends Figure {
    protected Shape iShapeFigure;
    protected BorderLayout iLayout;
    static FontRegistry registry = new FontRegistry();
    protected boolean isActivated = false;
    protected boolean needBorder = false;
    IFigure tooltip;

    static {
        registry.put("default", new FontData[]{new FontData("Sans", 9, 1)});
        registry.put("code", new FontData[]{new FontData("Sans", 9, 0)});
    }

    public ShapeCenteringFigure(boolean _needBorder, String labelText, IFigure tooltip) {
        this.needBorder = _needBorder;
        this.tooltip = tooltip;
        this.iLayout = new BorderLayout();
        LocalCoordinatePanel ptmp = new LocalCoordinatePanel();
        ptmp.setOpaque(true);
        ptmp.setLayoutManager((LayoutManager)new BorderLayout());
        FlowPage fp = new FlowPage();
        fp.setHorizontalAligment(2);
        fp.setMaximumSize(new Dimension(100, 100));
        TextFlow label = new TextFlow();
        label.setFont(registry.get("code"));
        label.setText(labelText);
        fp.add((IFigure)label);
        ptmp.add((IFigure)fp);
        ptmp.getLayoutManager().setConstraint((IFigure)fp, (Object)BorderLayout.CENTER);
        this.add((IFigure)ptmp);
        this.iLayout.setConstraint((IFigure)ptmp, (Object)BorderLayout.BOTTOM);
        LocalCoordinatePanel ptop = new LocalCoordinatePanel();
        ptop.setOpaque(true);
        ptop.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.createShapeFigure();
        ptop.add((IFigure)this.iShapeFigure);
        ptop.getLayoutManager().setConstraint((IFigure)this.iShapeFigure, (Object)new CenteringLocator());
        this.add((IFigure)ptop);
        this.iLayout.setConstraint((IFigure)ptop, (Object)BorderLayout.CENTER);
        this.setSize(10 + Math.max(this.iShapeFigure.getSize().width, fp.getPreferredSize().width), 3 + this.iShapeFigure.getSize().height + fp.getPreferredSize().height);
        this.setLayoutManager((LayoutManager)this.iLayout);
        this.setOpaque(true);
        if (this.needBorder) {
            this.setBorder((Border)new DashedBorder(ColorConstants.gray, 1));
        }
        this.isActivated = true;
    }

    protected abstract void createShapeFigure();

    protected boolean useLocalCoordinates() {
        return true;
    }

    public IFigure getToolTip() {
        return this.tooltip;
    }

    protected abstract Dimension getShapeDimension();

    protected class CenteringLocator
    implements Locator {
        protected CenteringLocator() {
        }

        public void relocate(IFigure target) {
            IFigure parent = target.getParent();
            int width = ShapeCenteringFigure.this.iShapeFigure.getSize().width;
            int height = ShapeCenteringFigure.this.iShapeFigure.getSize().height;
            int x = parent.getClientArea().width / 2 - width / 2;
            int y = parent.getClientArea().height / 2 - height / 2;
            target.setLocation(new Point(x, y));
        }
    }
}

