/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.common.labelproviders.natives;

import java.util.ArrayList;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;
import org.eclipse.viatra2.visualisation.common.labelproviders.HighlightableSmartLabelProvider;
import org.eclipse.viatra2.visualisation.common.labelproviders.natives.AbstractVisualisationFunction;

@VIATRANativeFunction(name="viz.highlight", params={@NativeFunctionParameter(isVarArg=false, name="highlightColor", description="(OPTIONAL) highlight color key (returned by getColor) to use", type={NativeFunctionParameter.ParameterType.STRING}), @NativeFunctionParameter(isVarArg=true, description="model element to highlight", name="modelElement", type={NativeFunctionParameter.ParameterType.MODEL_ELEMENT})}, returns={NativeFunctionParameter.ParameterType.BOOLEAN})
public class HighlightFunction
extends AbstractVisualisationFunction {
    @Override
    public Object run(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        String colorKey = null;
        ArrayList<IModelElement> elementsToHighlight = new ArrayList<IModelElement>();
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof String) {
                colorKey = (String)element;
            }
            if (element instanceof IModelElement) {
                elementsToHighlight.add((IModelElement)element);
            }
            ++n2;
        }
        for (IModelElement me : elementsToHighlight) {
            HighlightableSmartLabelProvider.highlightElement(me, colorKey);
        }
        return Boolean.TRUE;
    }

    public String getName() {
        return "viz.highlight";
    }

    public String getID() {
        return "viz.highlight";
    }

    public String getDescription() {
        return "Highlights an element in the visualization";
    }
}

