/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.content.FrameworkContainer;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;
import org.eclipse.viatra2.logger.Logger;
import org.eclipse.viatra2.visualisation.IVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.modelspace.ModelSpaceVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.view.ViatraVisualisationView;

public class VisualiseModelSpaceAction
extends AbstractFrameworkGUIAction {
    ModelSpaceVisualisationDescriptor descriptor;

    public VisualiseModelSpaceAction() {
        this.setText("Visualise Model Space");
        this.setToolTipText("Graph Visualisation for the Model Space");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS"));
    }

    public VisualiseModelSpaceAction(FrameworkTreeView part) {
        this();
        this.setupInternals(part);
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        this.refreshSelection();
        Object c = this.getFirstSelected();
        Logger log = this.iViatraFramework.getLogger();
        if (c instanceof FrameworkContainer) {
            IFramework framework = ((FrameworkContainer)c).getFramework();
            IModelSpace modelSpace = framework.getTopmodel();
            IModelManager manager = modelSpace.getModelManager();
            if (manager == null) {
                log.error("***The machine is not connected to a Model Space***");
                return;
            }
            ViatraVisualisationView view = ViatraVisualisationView.openView();
            IVisualisationDescriptor newDescriptor = view.getDescriptor(framework);
            if (newDescriptor == null || !(newDescriptor instanceof ModelSpaceVisualisationDescriptor)) {
                this.descriptor = new ModelSpaceVisualisationDescriptor();
                view.setDescriptor(framework, this.descriptor);
            } else {
                this.descriptor = (ModelSpaceVisualisationDescriptor)newDescriptor;
                IModelManager oldManager = this.descriptor.getModelManager();
                if (oldManager != null && !manager.equals(oldManager) && !MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Graph overwrite", (String)"Another model space is already visualised. Do you want to overwrite it?")) {
                    return;
                }
            }
            this.descriptor.setFramework(framework);
            this.descriptor.includeItem((IModelElement)manager.getRoot());
            this.descriptor.setModelManager(manager);
        }
    }
}

