/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace.actions.groups;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.visualisation.common.action.SelectProviderAction;
import org.eclipse.viatra2.visualisation.modelspace.datasource.AbstractModelSpaceProvider;
import org.eclipse.viatra2.visualisation.modelspace.datasource.FullModelSpaceProvider;
import org.eclipse.viatra2.visualisation.modelspace.datasource.ReducedModelSpaceProvider;
import org.eclipse.viatra2.visualisation.modelspace.datasource.filter.PreFilter;

public class ModelSpaceProviderGroup
extends ActionGroup {
    ReducedModelSpaceProvider reducedProvider = new ReducedModelSpaceProvider();
    FullModelSpaceProvider fullProvider = new FullModelSpaceProvider();
    List<AbstractModelSpaceProvider> providers = new ArrayList<AbstractModelSpaceProvider>();

    public ModelSpaceProviderGroup() {
        this.providers.add(this.reducedProvider);
        this.providers.add(this.fullProvider);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("Display Relations");
        manager.add((IContributionItem)menu);
        SelectProviderAction reducedAction = new SelectProviderAction("As Arcs", this.reducedProvider);
        menu.add((IAction)reducedAction);
        SelectProviderAction fullAction = new SelectProviderAction("As Nodes", this.fullProvider);
        reducedAction.setChecked(true);
        menu.add((IAction)fullAction);
    }

    public List<? extends AbstractModelSpaceProvider> getProviders() {
        return this.providers;
    }

    public AbstractModelSpaceProvider getDefaultProvider() {
        return this.reducedProvider;
    }

    public void setModelManager(IModelManager modelManager) {
        for (AbstractModelSpaceProvider provider : this.providers) {
            provider.setModelManager(modelManager);
        }
    }

    public void setFilter(PreFilter filter) {
        for (AbstractModelSpaceProvider provider : this.providers) {
            provider.setFilter(filter);
        }
    }
}

