/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.patterns.viewmodel;

import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relationship;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.TypeOf;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.AbstractViewModelElement;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPatternBody;

public class ViewPatternModelElement
extends AbstractViewModelElement {
    ModelElement element;
    ViewPatternBody body;

    public ModelElement getModelElement() {
        return this.element;
    }

    public void setModelElement(ModelElement entity) {
        this.element = entity;
    }

    public String toString() {
        String name = this.element.getName();
        return name;
    }

    public void setBody(ViewPatternBody body) {
        this.body = body;
    }

    public ViewPatternBody getBody() {
        return this.body;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public boolean isRelation() {
        return this.element instanceof Relation;
    }

    public boolean isEntity() {
        return this.element instanceof Entity;
    }

    public int getNumberOfRelationsFrom(ViewPatternModelElement target) {
        EList relationsFrom;
        if (this.isEntity() && target.isRelation() && (relationsFrom = ((Entity)this.element).getRelationsFrom()).contains((Object)target.element)) {
            return 1;
        }
        return 0;
    }

    public int getNumberOfRelationsTo(ViewPatternModelElement source) {
        EList relationsFrom;
        if (this.isEntity() && source.isRelation() && (relationsFrom = ((Entity)this.element).getRelationsTo()).contains((Object)source.element)) {
            return 1;
        }
        return 0;
    }

    private String getTypeString(ModelElement element) {
        for (Relationship rel : element.getSuperRelationships()) {
            if (!(rel instanceof TypeOf)) continue;
            return rel.getSupplierStr();
        }
        return "";
    }

    @Override
    public String getTypeString() {
        String string = this.getTypeString(this.element);
        if (string != "") {
            int pos = string.lastIndexOf(".");
            string = string.substring(pos + 1);
            return string;
        }
        if (this.isEntity()) {
            return "Entity";
        }
        if (this.isRelation()) {
            return "Relation";
        }
        return "Model Element";
    }
}

