/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.editor.text.light.vtcl;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.viatra2.editor.text.Activator;
import org.eclipse.viatra2.editor.text.light.VTEAutoIndentStrategy;
import org.eclipse.viatra2.editor.text.light.VTEColorProvider;
import org.eclipse.viatra2.editor.text.light.VTEColorToken;
import org.eclipse.viatra2.editor.text.light.vtcl.VTCLCodeScanner;

public class VTCLConfiguration
extends SourceViewerConfiguration {
    private VTCLCodeScanner iCodeScanner = null;
    private VTEColorProvider iColorProvider = null;
    private VTEColorToken iColorToken = null;

    public VTCLConfiguration(VTEColorProvider cm) {
        this.iColorProvider = cm;
        VTEColorProvider.initializeDefaults(Activator.getDefault().getPreferenceStore());
        this.iColorToken = new VTEColorToken();
        this.iColorToken.COMMENT = new Token((Object)new TextAttribute(this.iColorProvider.getColor("comment"), null, 2));
        this.iColorToken.KEYWORD = new Token((Object)new TextAttribute(this.iColorProvider.getColor("keyword"), null, 1));
        this.iColorToken.STRING = new Token((Object)new TextAttribute(this.iColorProvider.getColor("string")));
        this.iColorToken.OTHER = new Token((Object)new TextAttribute(this.iColorProvider.getColor("default")));
        this.iCodeScanner = new VTCLCodeScanner(this.iColorProvider, this.iColorToken);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.iCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new VTEAutoIndentStrategy()};
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new IAnnotationHover(){

            public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
                String r = "Problems:\n";
                Iterator it = sourceViewer.getAnnotationModel().getAnnotationIterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof MarkerAnnotation)) continue;
                    MarkerAnnotation ann = (MarkerAnnotation)o;
                    try {
                        int line = (Integer)ann.getMarker().getAttribute("lineNumber");
                        if (line != lineNumber && line != lineNumber - 1 && line != lineNumber + 1) continue;
                        r = String.valueOf(r) + " - " + ann.getText() + "\n";
                    }
                    catch (CoreException coreException) {}
                }
                return r;
            }
        };
    }
}

