/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.commands;

import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommand;
import org.eclipse.viatra2.treeeditor.properties.VPMProperties;

public class ChangePropertyCommand
extends ViatraEditorCommand {
    IModelElement target;
    String target_name;
    VPMProperties kind;
    String newValue;
    Integer intValue;

    public void setIntValue(Integer intValue) {
        this.intValue = intValue;
    }

    public void setNewValue(String oldValue) {
        this.newValue = oldValue;
    }

    public void setTarget(IModelElement target) {
        this.target = target;
        this.target_name = target.getFullyQualifiedName();
    }

    public void setKind(VPMProperties kind) {
        this.kind = kind;
    }

    @Override
    public void execute() throws VPMCoreException {
        this.target = this.Lookup(this.target, this.target_name);
        switch (this.kind) {
            case VALUE: {
                this.iTransactionID = this.target.getModelSpace().getTransactionManager().beginUndoableTransaction();
                this.target.getModelSpace().getModelManager().setValue((IEntity)this.target, this.newValue);
                this.target_name = this.target.getFullyQualifiedName();
                this.target.getModelSpace().getTransactionManager().commitTransaction();
                break;
            }
            case VIEWINFO: {
                this.iTransactionID = this.target.getModelSpace().getTransactionManager().beginUndoableTransaction();
                this.target.getModelSpace().getModelManager().setViewInfo(this.target, this.newValue);
                this.target_name = this.target.getFullyQualifiedName();
                this.target.getModelSpace().getTransactionManager().commitTransaction();
                break;
            }
            case ISFINALTYPE: {
                this.iTransactionID = this.target.getModelSpace().getTransactionManager().beginUndoableTransaction();
                this.target.getModelSpace().getModelManager().setIsFinalType(this.target, this.intValue.equals(1));
                this.target_name = this.target.getFullyQualifiedName();
                this.target.getModelSpace().getTransactionManager().commitTransaction();
                break;
            }
            case ISAGGREGATION: {
                this.iTransactionID = this.target.getModelSpace().getTransactionManager().beginUndoableTransaction();
                this.target.getModelSpace().getModelManager().setRelationIsAggregation((IRelation)this.target, this.intValue.equals(1));
                this.target_name = this.target.getFullyQualifiedName();
                this.target.getModelSpace().getTransactionManager().commitTransaction();
                break;
            }
            case MULTIPLICITY: {
                this.iTransactionID = this.target.getModelSpace().getTransactionManager().beginUndoableTransaction();
                this.target.getModelSpace().getModelManager().setRelationMultiplicity((IRelation)this.target, EMultiplicityKind.values()[this.intValue]);
                this.target_name = this.target.getFullyQualifiedName();
                this.target.getModelSpace().getTransactionManager().commitTransaction();
            }
        }
    }

    @Override
    public void undo() throws VPMCoreException {
        this.target = this.Lookup(this.target, this.target_name);
        if (this.target != null) {
            this.target.getModelSpace().getTransactionManager().undoTransaction(this.iTransactionID);
            this.target_name = this.target.getFullyQualifiedName();
        }
    }
}

