/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.menu;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;
import org.eclipse.viatra2.treeeditor.providers.ViatraContentProvider;

public class ViatraTreeEditorMenuListener
implements IMenuListener {
    private ViatraTreeEditor iVTE;

    public ViatraTreeEditorMenuListener(ViatraTreeEditor vte) {
        this.iVTE = vte;
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.removeAll();
        boolean isEntitySelected = false;
        boolean isElementSelected = false;
        boolean isRelationSelected = false;
        boolean isRelationTargetSelected = false;
        ISelection sel = this.iVTE.getSite().getSelectionProvider().getSelection();
        if (sel instanceof StructuredSelection) {
            for (Object curr : (StructuredSelection)sel) {
                if (!isElementSelected) {
                    if (this.iVTE.getDeleteAction() != null) {
                        manager.add((IAction)this.iVTE.getDeleteAction());
                    } else {
                        manager.add((IAction)this.iVTE.getLocalDeleteAction());
                    }
                    manager.add((IAction)this.iVTE.getRenameAction());
                    manager.add((IContributionItem)new Separator("new"));
                    manager.add((IAction)this.iVTE.getNewRelationAction());
                    manager.add((IContributionItem)new Separator("misc"));
                    manager.add((IAction)this.iVTE.getExportAction());
                    manager.add((IContributionItem)new Separator());
                    isElementSelected = true;
                }
                if (curr instanceof IEntity && !isEntitySelected) {
                    manager.appendToGroup("new", (IAction)this.iVTE.getNewEntityAction());
                    isEntitySelected = true;
                }
                if (curr instanceof IRelation && !isRelationSelected) {
                    manager.add((IAction)this.iVTE.getNavigateRelationAction());
                    isRelationSelected = true;
                }
                if (!(curr instanceof ViatraContentProvider.TargetRelationDummy) || isRelationTargetSelected) continue;
                manager.add(this.iVTE.getNavigateRelationSourceAction());
                isRelationTargetSelected = true;
            }
            manager.add((IContributionItem)new Separator());
            for (String key : this.iVTE.getContributedActions().keySet()) {
                IMenuManager target = manager;
                List<ViatraTreeEditorSelectionAction> cAs = this.iVTE.getContributedActions().get(key);
                if (!"Default".equals(key)) {
                    target = new MenuManager(key);
                    manager.add((IContributionItem)target);
                }
                for (ViatraTreeEditorSelectionAction a : cAs) {
                    target.add((IAction)a);
                }
            }
        }
    }
}

