/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.properties.VPMProperties;
import org.eclipse.viatra2.treeeditor.properties.VPMPropertyCategory;
import org.eclipse.viatra2.treeeditor.properties.VPMPropertySource;
import org.eclipse.viatra2.treeeditor.properties.util.LabelTranslator;

public class VPMPropertySheetPage
extends PropertySheetPage
implements ICoreNotificationListener {
    ViatraTreeEditor iEditor;
    IModelElement iElement;
    VPMPropsSorter iSorter = new VPMPropsSorter();

    public VPMPropertySheetPage(ViatraTreeEditor e) {
        this.iEditor = e;
        this.setSorter(this.iSorter);
        this.setPropertySourceProvider(new IPropertySourceProvider(){

            public IPropertySource getPropertySource(Object object) {
                if (object instanceof IModelElement) {
                    return new VPMPropertySource((IModelElement)object, VPMPropertySheetPage.this.iEditor);
                }
                return null;
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object o;
        super.selectionChanged(part, selection);
        if (this.iElement != null) {
            this.iElement.getModelSpace().getNotificationManager().removeNotificationListener(this.iElement, (ICoreNotificationListener)this);
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IModelElement) {
            this.iElement = (IModelElement)o;
        }
    }

    public void refresh() {
        TreeItem[] is = ((Tree)this.getControl()).getSelection();
        super.refresh();
        ((Tree)this.getControl()).setSelection(is);
        ((Tree)this.getControl()).showSelection();
    }

    public void actionPerformed(ICoreNotificationObject notification) {
        this.refresh();
    }

    public int getListenerCategory() {
        return 0;
    }

    protected class VPMPropsSorter
    extends PropertySheetSorter {
        protected VPMPropsSorter() {
        }

        public int compare(IPropertySheetEntry entryA, IPropertySheetEntry entryB) {
            VPMProperties p1 = LabelTranslator.getVPMProperty(entryA.getDisplayName());
            VPMProperties p2 = LabelTranslator.getVPMProperty(entryB.getDisplayName());
            return p1.compareTo(p2);
        }

        public int compareCategories(String categoryA, String categoryB) {
            VPMPropertyCategory c1 = LabelTranslator.getPropCategory(categoryA);
            VPMPropertyCategory c2 = LabelTranslator.getPropCategory(categoryB);
            return c1.compareTo(c2);
        }
    }
}

