/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.providers;

import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.providers.ViatraTreeEventListener;

public class ViatraTreeMouseListener
implements MouseListener {
    protected Tree iTreeControl;
    protected ViatraTreeEditor iVTE;

    public ViatraTreeMouseListener(ViatraTreeEditor vte, Tree tc) {
        this.iTreeControl = tc;
        this.iVTE = vte;
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.iTreeControl != null) {
            TreeItem item = this.iTreeControl.getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            IModelElement me = (IModelElement)item.getData();
            if (me.getFullyQualifiedName().length() < 1) {
                return;
            }
            TreeEditor editor = new TreeEditor(this.iTreeControl);
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.minimumWidth = 64;
            ViatraTreeEventListener list = new ViatraTreeEventListener(me, editor, this.iVTE);
            Text celleditor = new Text((Composite)this.iTreeControl, 0);
            String value = "";
            if (me instanceof IEntity && ((IEntity)me).getValue().length() > 0) {
                value = " {" + ((IEntity)me).getValue() + "}";
            }
            celleditor.setText(String.valueOf(me.getName()) + value);
            celleditor.addFocusListener((FocusListener)list);
            celleditor.addKeyListener((KeyListener)list);
            celleditor.addModifyListener((ModifyListener)list);
            celleditor.selectAll();
            celleditor.setFocus();
            editor.setEditor((Control)celleditor, item);
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }
}

