/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.executionEnvironment.BlockRuleExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.ExecutionMode;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternMatcherParameters;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.BlockRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.CollectionIteratorRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.ForallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotationElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.SymbolicRuleParameter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.DirectionKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.GTRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.ContainmentConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.interpreters.IProgressReport;

public abstract class BlockRuleInterpreterHelper {
    static HashMap<Variable, Scope> getScopesFromContainmentConstraints(IExecutionEnvironment executionEnvironment, CollectionIteratorRule rule) throws ViatraTransformationException {
        EList containmentConstraints = rule.getContainmentConstraints();
        HashMap<Variable, Scope> parameterScopes = new HashMap<Variable, Scope>();
        for (Object cC : containmentConstraints) {
            ContainmentConstraint containmentConstraint = (ContainmentConstraint)cC;
            if (containmentConstraint.getParent() != null) {
                Object constraintParent = TermEvaluator.getInstance().evaluate(executionEnvironment, containmentConstraint.getParent());
                if (constraintParent instanceof IEntity) {
                    parameterScopes.put(containmentConstraint.getVariable(), new Scope(Integer.valueOf(containmentConstraint.getMode().getValue()), (IModelElement)TermEvaluator.getInstance().evaluate(executionEnvironment, containmentConstraint.getParent())));
                    continue;
                }
                String[] context = new String[]{containmentConstraint.getVariable().getName()};
                ASMInterpreterException e = new ASMInterpreterException("The {1} Scope is not an Entity", context, (AnnotatedElement)containmentConstraint.getVariable());
                throw e.addNewStackElement((EObject)rule);
            }
            parameterScopes.put(containmentConstraint.getVariable(), new Scope());
        }
        return parameterScopes;
    }

    static boolean evaulateDoPartofGTRuleInvocation(GTRule gtRule, Object[] match, BlockRule blockRule, IExecutionEnvironment blockRuleExecutionEnvironment, GTRuleInvocation ruleInvocation, IProgressReport pr) throws ViatraTransformationException {
        if (blockRule.getBody() == null) {
            return Boolean.TRUE;
        }
        GTRuleInvocation gtRuleInvocation = ((CollectionIteratorRule)blockRule).getGtrule();
        int i = 0;
        while (i < gtRule.getSymParameters().size()) {
            Object ActualTerm;
            if (!(((SymbolicRuleParameter)gtRule.getSymParameters().get(i)).getDirection().equals((Object)DirectionKind.IN_LITERAL) || !match[i].equals(ValueKind.UNDEF_LITERAL) || (ActualTerm = ruleInvocation.getActualParameters().get(i)) instanceof VariableReference && ((CollectionIteratorRule)blockRule).getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable()))) {
                String[] context = new String[]{((SymbolicRuleParameter)gtRule.getSymParameters().get(i)).getName(), gtRule.getName()};
                throw new ASMInterpreterException("The {1} variable is not bound after the execution of the {2} gtrule", context, (AnnotatedElement)blockRule);
            }
            try {
                if (gtRuleInvocation.getActualParameters().get(i) instanceof VariableReference) {
                    Variable variable = ((VariableReference)gtRuleInvocation.getActualParameters().get(i)).getVariable();
                    blockRuleExecutionEnvironment.setVariableValue(variable, match[i]);
                }
            }
            catch (ViatraTransformationException e) {
                String n = "";
                if (gtRuleInvocation.getActualParameters().get(i) instanceof VariableReference) {
                    n = ((VariableReference)gtRuleInvocation.getActualParameters().get(i)).getVariable().getName();
                }
                String[] context = new String[]{n, e.getMessage()};
                throw new ASMInterpreterException(blockRule instanceof ForallRule ? "Error at setting the initial value of the {1} variable in the forall execution context: {2} " : "Error at setting the initial value of the {1} variable in the choose execution context: {2} ", context, (AnnotatedElement)blockRule);
            }
            ++i;
        }
        return RuleInterpreter.getInstance().interpretRule(blockRuleExecutionEnvironment, blockRule.getBody(), pr);
    }

    /*
     * Unable to fully structure code
     */
    static PatternMatcherParameters getGTRuleMatchParameters(IExecutionEnvironment executionEnvironment, CollectionIteratorRule ruleToBeInterpreted, Map<Variable, Scope> parameterScopes, GTRule gtRule, GTRuleInvocation invocation) throws ViatraTransformationException {
        patternParams = new Object[invocation.getActualParameters().size()];
        quantificationOrder = new Integer[invocation.getActualParameters().size()];
        patternCallSignatures = new PatternCallSignature[invocation.getActualParameters().size()];
        outerVariableCounterForQuantificationOrder = ruleToBeInterpreted.getLocalVariables().size();
        i = 0;
        while (i < invocation.getActualParameters().size()) {
            block24: {
                block23: {
                    ActualTerm = invocation.getActualParameters().get(i);
                    symParam = (SymbolicRuleParameter)gtRule.getSymParameters().get(i);
                    pcs = new PatternCallSignature();
                    patternParams[i] = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)ActualTerm);
                    if (ActualTerm instanceof VariableReference && ruleToBeInterpreted.getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable())) {
                        if (ruleToBeInterpreted instanceof ForallRule) {
                            pcs.setExecutionMode(ExecutionMode.MULTIPLE_RESULTS);
                        } else {
                            pcs.setExecutionMode(ExecutionMode.SINGLE_RESULT);
                        }
                        isQuantifiedVariableinLHS = false;
                        j = 0;
                        while (j < gtRule.getPrecondition().getActualParameters().size()) {
                            if (((VariableReference)gtRule.getPrecondition().getActualParameters().get(j)).getVariable().equals(symParam.getVariable())) {
                                isQuantifiedVariableinLHS = true;
                            }
                            ++j;
                        }
                        if (!isQuantifiedVariableinLHS) {
                            context = new String[]{((VariableReference)ActualTerm).getVariable().getName(), gtRule.getName()};
                            e = new ASMInterpreterException("The {1} variable is quantified but not used in the LHS of the {2} gtRule", context, (AnnotatedElement)gtRule);
                            throw e.addNewStackElement((EObject)ruleToBeInterpreted);
                        }
                    } else {
                        pcs.setExecutionMode(ExecutionMode.SINGLE_RESULT);
                    }
                    if (!symParam.getDirection().equals((Object)DirectionKind.IN_LITERAL)) break block23;
                    if (patternParams[i] == null || ValueKind.UNDEF_LITERAL.equals(patternParams[i])) {
                        context = new String[]{symParam.getVariable().getName(), gtRule.getName()};
                        e = new ASMInterpreterException("The value of the {1} variable can not be 'UNDEF' as it is an INPUT parameter for the {2} gtRule", context, (AnnotatedElement)gtRule);
                        throw e.addNewStackElement((EObject)ruleToBeInterpreted);
                    }
                    pcs.setParameterMode(ParameterMode.INPUT);
                    break block24;
                }
                if (!symParam.getDirection().equals((Object)DirectionKind.OUT_LITERAL)) ** GOTO lbl45
                if (ActualTerm instanceof VariableReference) {
                    pcs.setParameterMode(ParameterMode.OUTPUT);
                    patternParams[i] = ValueKind.UNDEF_LITERAL;
                } else {
                    context = new String[]{symParam.getVariable().getName(), gtRule.getName()};
                    e = new ASMInterpreterException("The OUTPUT {1} parameter of the {2} gtRule is invoked with a nonvariable parameter, thus the output value of the gtrule invocation cannot be written into the caller variable", context, (AnnotatedElement)gtRule);
                    throw e.addNewStackElement((EObject)ruleToBeInterpreted);
lbl45:
                    // 1 sources

                    if (patternParams[i] == null || ValueKind.UNDEF_LITERAL.equals(patternParams[i])) {
                        context = new String[]{symParam.getVariable().getName(), gtRule.getName()};
                        e = new ASMInterpreterException("The value of the {1} variable can not be 'UNDEF' as it is an INPUT parameter for the {2} gtRule", context, (AnnotatedElement)gtRule);
                        throw e.addNewStackElement((EObject)ruleToBeInterpreted);
                    }
                    pcs.setParameterMode(ParameterMode.INPUT);
                }
            }
            if (ActualTerm instanceof VariableReference) {
                if (parameterScopes.containsKey(((VariableReference)ActualTerm).getVariable())) {
                    pcs.setParameterScope(parameterScopes.get(((VariableReference)ActualTerm).getVariable()));
                } else {
                    pcs.setParameterScope(new Scope());
                }
            } else {
                pcs.setParameterScope(new Scope());
            }
            if (ruleToBeInterpreted instanceof ForallRule) {
                if (ActualTerm instanceof VariableReference) {
                    if (ruleToBeInterpreted.getLocalVariables().indexOf((Object)((VariableReference)ActualTerm).getVariable()) == -1) {
                        if (invocation.getActualParameters().size() == outerVariableCounterForQuantificationOrder) {
                            BlockRuleInterpreterHelper.getNoneUsedVariable(ruleToBeInterpreted);
                        }
                        quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                        ++outerVariableCounterForQuantificationOrder;
                    } else {
                        quantificationOrder[ruleToBeInterpreted.getLocalVariables().indexOf((Object)((VariableReference)ActualTerm).getVariable())] = i;
                    }
                } else {
                    if (invocation.getActualParameters().size() == outerVariableCounterForQuantificationOrder) {
                        BlockRuleInterpreterHelper.getNoneUsedVariable(ruleToBeInterpreted);
                    }
                    quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                    ++outerVariableCounterForQuantificationOrder;
                }
            }
            patternCallSignatures[i] = pcs;
            ++i;
        }
        return new PatternMatcherParameters(patternCallSignatures, patternParams, quantificationOrder);
    }

    static void getNoneUsedVariable(CollectionIteratorRule ruleToBeInterpreted) throws ViatraTransformationException {
        String name = ruleToBeInterpreted.getCondition() instanceof GTPatternCall ? String.valueOf(((GTPatternCall)ruleToBeInterpreted.getCondition()).getCalledPattern().getName()) + " pattern" : String.valueOf(ruleToBeInterpreted.getGtrule().getRule().getName()) + " GT Rule";
        EList actualParamater = ruleToBeInterpreted.getCondition() instanceof GTPatternCall ? ((GTPatternCall)ruleToBeInterpreted.getCondition()).getActualParameters() : ruleToBeInterpreted.getGtrule().getActualParameters();
        int j = 0;
        while (j < ruleToBeInterpreted.getLocalVariables().size()) {
            Variable locVar = (Variable)ruleToBeInterpreted.getLocalVariables().get(j);
            boolean usedInRule = false;
            int k = 0;
            while (k < actualParamater.size()) {
                if (actualParamater.get(k) instanceof VariableReference && ((VariableReference)actualParamater.get(k)).getVariable().equals(locVar)) {
                    usedInRule = true;
                }
                ++k;
            }
            if (!usedInRule) {
                String[] context = new String[]{locVar.getName(), name};
                throw new ASMInterpreterException(" The {1} variable is quantified but not used in the {2}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            ++j;
        }
        String[] context = new String[]{name};
        throw new ASMInterpreterException("[INTERNAL ERROR] A FATAL error occured during the execution of the {1} rule.", context, (AnnotatedElement)ruleToBeInterpreted);
    }

    /*
     * Enabled aggressive block sorting
     */
    static PatternMatcherParameters getMatchParameters(IExecutionEnvironment executionEnvironment, CollectionIteratorRule ruleToBeInterpreted, Map<Variable, Scope> parameterScopes) throws ViatraTransformationException {
        CollectionIteratorRule iteratorBlockRule = ruleToBeInterpreted;
        int paramSize = ((GTPatternCall)iteratorBlockRule.getCondition()).getActualParameters().size();
        if (paramSize < iteratorBlockRule.getLocalVariables().size()) {
            BlockRuleInterpreterHelper.getNoneUsedVariable(ruleToBeInterpreted);
        }
        Object[] patternParams = new Object[paramSize];
        Integer[] quantificationOrder = new Integer[paramSize];
        PatternCallSignature[] patternCallSignatures = new PatternCallSignature[paramSize];
        int outerVariableCounterForQuantificationOrder = iteratorBlockRule.getLocalVariables().size();
        int i = 0;
        while (i < paramSize) {
            Variable variable;
            PatternCallSignature pcs;
            Object ActualTerm;
            block17: {
                ActualTerm = ((GTPatternCall)iteratorBlockRule.getCondition()).getActualParameters().get(i);
                pcs = new PatternCallSignature();
                patternParams[i] = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)ActualTerm);
                if ((Term)ActualTerm instanceof VariableReference && ruleToBeInterpreted instanceof ForallRule && iteratorBlockRule.getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable())) {
                    pcs.setExecutionMode(ExecutionMode.MULTIPLE_RESULTS);
                } else {
                    pcs.setExecutionMode(ExecutionMode.SINGLE_RESULT);
                }
                if (patternParams[i] == null || ValueKind.UNDEF_LITERAL.equals(patternParams[i])) {
                    if ((Term)ActualTerm instanceof VariableReference && iteratorBlockRule.getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable())) {
                        pcs.setParameterMode(ParameterMode.OUTPUT);
                        break block17;
                    } else {
                        String[] context = new String[]{"" + i};
                        throw new ASMInterpreterException("As the {1}. parameter is not quantified by the forall/choose rule it must be an INPUT parameter with a non-UNDEF value.", context, (AnnotatedElement)iteratorBlockRule);
                    }
                }
                pcs.setParameterMode(ParameterMode.INPUT);
            }
            if (ActualTerm instanceof VariableReference) {
                variable = ((VariableReference)ActualTerm).getVariable();
                if (parameterScopes.containsKey(variable)) {
                    pcs.setParameterScope(parameterScopes.get(variable));
                } else {
                    pcs.setParameterScope(new Scope());
                }
            } else {
                pcs.setParameterScope(new Scope());
            }
            patternCallSignatures[i] = pcs;
            if (ruleToBeInterpreted instanceof ForallRule) {
                if (ActualTerm instanceof VariableReference) {
                    variable = ((VariableReference)ActualTerm).getVariable();
                    if (iteratorBlockRule.getLocalVariables().indexOf((Object)variable) == -1) {
                        if (paramSize == outerVariableCounterForQuantificationOrder) {
                            BlockRuleInterpreterHelper.getNoneUsedVariable(ruleToBeInterpreted);
                        }
                        quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                        ++outerVariableCounterForQuantificationOrder;
                    } else {
                        quantificationOrder[iteratorBlockRule.getLocalVariables().indexOf((Object)variable)] = i;
                    }
                } else {
                    quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                    ++outerVariableCounterForQuantificationOrder;
                }
            }
            ++i;
        }
        return new PatternMatcherParameters(patternCallSignatures, patternParams, quantificationOrder);
    }

    static BlockRuleExecutionEnvironment getNewExecutionEnvironment(IExecutionEnvironment executionEnvironment, CollectionIteratorRule ruleToBeInterpreted) {
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), ruleToBeInterpreted.getBody());
        Hashtable<Variable, Object> variables = new Hashtable<Variable, Object>(executionEnvironment.getVariableValues());
        for (Object variable : ruleToBeInterpreted.getLocalVariables()) {
            variables.put((Variable)variable, ValueKind.UNDEF_LITERAL);
        }
        forallRuleExecutionEnvironment.onBegin(variables);
        return forallRuleExecutionEnvironment;
    }

    static Collection<IMatching> reorder(GTPattern gtPattern, Collection<IMatching> matches) {
        Integer orderColoumn = null;
        boolean orderDesc = false;
        String orderType = "string";
        for (Object annot : gtPattern.getRuntimeAnnotations()) {
            RuntimeAnnotation annot2 = (RuntimeAnnotation)annot;
            if (!"@orderby".equals(annot2.getAnnotationName().toLowerCase())) continue;
            for (Object oRel : annot2.getElements()) {
                RuntimeAnnotationElement rel = (RuntimeAnnotationElement)oRel;
                if ("col".equals(rel.getKey().toLowerCase())) {
                    try {
                        orderColoumn = Integer.parseInt(rel.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("order".equals(rel.getKey().toLowerCase()) && "desc".equals(rel.getValue().toLowerCase())) {
                    orderDesc = true;
                    continue;
                }
                if (!"type".equals(rel.getKey().toLowerCase())) continue;
                orderType = rel.getValue().toLowerCase();
            }
        }
        if (orderColoumn != null) {
            final boolean desc = orderDesc;
            final HashMap<IMatching, Comparable> keys = new HashMap<IMatching, Comparable>();
            for (IMatching match : matches) {
                Object col = match.lookup(orderColoumn.intValue());
                Object key = null;
                if (col != null) {
                    if (col instanceof IEntity) {
                        if ("name".equals(orderType)) {
                            key = ((IModelElement)col).getName();
                        } else if ("name-nocase".equals(orderType)) {
                            key = ((IModelElement)col).getName().toLowerCase();
                        } else if ("fqn".equals(orderType)) {
                            key = ((IModelElement)col).getFullyQualifiedName();
                        } else if ("fqn-nocase".equals(orderType)) {
                            key = ((IModelElement)col).getFullyQualifiedName().toLowerCase();
                        } else {
                            String value = ((IEntity)col).getValue();
                            key = "double".equals(orderType) ? Double.valueOf(Double.parseDouble(value)) : ("integer".equals(orderType) ? Integer.valueOf(Integer.parseInt(value)) : ("nocase".equals(orderType) ? value.toLowerCase() : ("value-nocase".equals(orderType) ? value.toLowerCase() : value)));
                        }
                    } else {
                        key = col instanceof Comparable ? (Comparable)col : col.toString();
                    }
                }
                keys.put(match, (Comparable)key);
            }
            ArrayList<IMatching> matchList = new ArrayList<IMatching>(matches);
            Collections.sort(matchList, new Comparator<IMatching>(){

                @Override
                public int compare(IMatching o1, IMatching o2) {
                    int compareResult = ((Comparable)keys.get(o1)).compareTo(keys.get(o2));
                    return desc ? -compareResult : compareResult;
                }
            });
            matches = matchList;
        }
        return matches;
    }
}

