/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.rules;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ASMRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdate;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdateASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdateVariable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.interpreters.IProgressReport;

public class RuleUpdateInterpreter
extends RuleInterpreter {
    private static RuleUpdateInterpreter _instance = new RuleUpdateInterpreter();

    public static RuleUpdateInterpreter getInstance() {
        return _instance;
    }

    private RuleUpdateInterpreter() {
    }

    @Override
    public Boolean interpretRule(IExecutionEnvironment executionEnvironment, ASMRuleInvocation ruleToBeInterpreted, IProgressReport pr) throws ViatraTransformationException {
        RuleUpdate ruleUpdate = (RuleUpdate)ruleToBeInterpreted;
        if (ruleUpdate instanceof RuleUpdateVariable) {
            Variable var = ((RuleUpdateVariable)ruleUpdate).getVariable().getVariable();
            try {
                executionEnvironment.setVariableValue(var, TermEvaluator.getInstance().evaluate(executionEnvironment, ((RuleUpdateVariable)ruleUpdate).getValue()));
                return Boolean.TRUE;
            }
            catch (ViatraTransformationException e) {
                String[] context = new String[]{var.getName(), e.getMessage()};
                throw new ASMInterpreterException("Error at setting the value of the {1} variable by the update rule: {2}", context, (AnnotatedElement)ruleUpdate);
            }
        }
        if (ruleUpdate instanceof RuleUpdateASMFunction) {
            BasicEList paramList = new BasicEList();
            for (Term location : ((RuleUpdateASMFunction)ruleUpdate).getLocations()) {
                paramList.add(TermEvaluator.getInstance().evaluate(executionEnvironment, location));
            }
            executionEnvironment.updateASMFunction(((RuleUpdateASMFunction)ruleUpdate).getFunction(), (EList)paramList, TermEvaluator.getInstance().evaluate(executionEnvironment, ((RuleUpdateASMFunction)ruleUpdate).getValue()));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static /* bridge */ /* synthetic */ RuleInterpreter getInstance() {
        return RuleUpdateInterpreter.getInstance();
    }
}

