/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateEntity;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.VariableSearchGraphNode;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class CreateEntityWithVariableContainment
extends CreateEntity {
    VariableSearchGraphNode container;

    public CreateEntityWithVariableContainment(int variableI, IModelManager manager, VariableSearchGraphNode con) {
        super(variableI, manager);
        this.container = con;
    }

    @Override
    protected boolean create(MatchingFrame frame) throws GTOperationException {
        IEntity tempContainer = null;
        try {
            tempContainer = (IEntity)frame.getValue(this.container.getId());
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.container.getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not an Entity", context, this.container.getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (tempContainer == null) {
            String[] context = new String[]{this.container.getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.container.getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            frame.setValue(this.variableIndex, this.manager.newEntity(tempContainer));
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] Entity '{1}' creation failed due to: {2} ", context, frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement());
        }
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.variableIndex + " in " + this.container;
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement();
    }
}

